<?php

namespace App\Http\Controllers;
use App\Models\client;

use App\Models\ville;
use App\Models\statut;
use App\Models\caisse;
use App\Models\catclientfrn;
use App\Models\produit;
use App\Models\stock;
use App\Models\vente;
use App\Models\detaille_vente;
use App\Models\avoir;
use App\Models\hystoriqprix;
use App\Models\avoir_detaille;
use Illuminate\Http\Request;
use App\Models\hystorique_factur;
class AvoirController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
      
    }


    public function avoir(Request $request)
    {
   
        $clients = client::all();
        $villes = ville::all();
        $statuts = statut::all();
        $catclientfrns = catclientfrn::all();
        return view('admin.avoir', [

            'clients' => $clients,
            'villes' => $villes,
            'statcatclientfrnsuts' => $catclientfrns,
            'statuts' => $statuts,
        ]);
     
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }
    public function modif_avoir(Request $request)
    {

  

            $id = $request->idavoir;
            $avoir = avoir::where('id', $id)->first();
            $avoir_detaille = avoir_detaille::where('avoir_id', $id)->get();
            return view('admin.modif_avoir',['avoir'=>$avoir,'avoir_detaille' => $avoir_detaille]);
           
    }
    public function modifeavoirjson($id)
    {
        $avoir = avoir::where('id', $id)->first();
        $avoir_detaille = avoir_detaille::where('avoir_id', $id)->with('avoir')->get();


        return response()->json(['avoir' => $avoir, 'avoir_detaille' => $avoir_detaille]);
    }
    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
     
        $avoir = new avoir();
        $avoir->user_id = Auth()->user()->id;
        $avoir->prixtotal = $request->prixtotal;
        $avoir->client_id = $request->client;
        $avoir->vente_id = 26;


        $avoir->comment = 'uuuu';
    

        $avoir->save();
   //trasabilite
   $hystorique_factur= new hystorique_factur();
   $hystorique_factur->facture_id = $avoir->id;
   $hystorique_factur->user_id=Auth()->user()->id;
   $hystorique_factur->catfacture_id=1; // 1 cree 2 modifier 3supprimer;
   $hystorique_factur->typecasse_id=2;// 1 vente 2 avoir 3reglement 4 achat 5 commande 6 devis;
   $hystorique_factur->save();


        foreach ($request->cart as $req => $key) {

            $avoir_detaille = new avoir_detaille();
         
            $avoir_detaille->avoir_id = $avoir->id;
            $avoir_detaille->produit_id = $request->cart[$req]['id'];
            $avoir_detaille->quantite = $request->cart[$req]['quantite'];
            $avoir_detaille->x = $request->cart[$req]['x']; //twli prix vente
            $avoir_detaille->comme = 'rrr';
            $avoir_detaille->nom = $request->cart[$req]['nom'];
            $avoir_detaille->prixvents = $request->cart[$req]['prixvents'];
            $avoir_detaille->prixun = 20;
            $avoir_detaille->save();
      
        if( $avoir_detaille->save()){
            $produit=produit::where('id',$request->cart[$req]['id'])->first();
            $produit->stock+=$request->cart[$req]['quantite'];
            $produit->save();
     if( $produit->save()){
        $stock= new stock();
        $stock->user_id=Auth()->user()->id;
        $stock->produit_id=$produit->id;
        $stock->mouvement_id=2;
        $stock->qty+=$request->cart[$req]['quantite'];
        $stock->save();
     }
  }

         }
         $caisse = new caisse();
         $caisse->typecasse_id=2;
         $caisse->client_id = $request->client;
         $caisse->montant = -$request->prixtotal;
         $caisse->entrer_id = $avoir->id;
         $caisse->save();
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\avoir  $avoir
     * @return \Illuminate\Http\Response
     */
    public function facture_avoir()
    {
        $avoirs=avoir::all();
        return view('admin.facture_avoir',['avoirs'=>$avoirs]);
    }
    public function modifier_avoir(Request $request, $id)
    {
     
        $avoir = avoir::where('id', $id)->first();
        $avoir->user_id = Auth()->user()->id;
        $avoir->prixtotal = $request->prixtotal;
        $avoir->client_id = $request->client;
        $avoir->vente_id = 26;


        $avoir->comment = 'uuuu';
    

        $avoir->save();

           //trasabilite
   $hystorique_factur= new hystorique_factur();
   $hystorique_factur->facture_id = $avoir->id;
   $hystorique_factur->user_id=Auth()->user()->id;
   $hystorique_factur->catfacture_id=2; // 1 cree 2 modifier 3supprimer;
   $hystorique_factur->typecasse_id=2;// 1 vente 2 avoir 3reglement 4 achat 5 commande 6 devis;
   $hystorique_factur->save();


//hwayj moochtaraka

$caisse=caisse::where('typecasse_id', 2)
->where('entrer_id', $avoir->id)
->first();
if($caisse){
$caisse->delete();}
//supprim cheque



        
     
            if ($avoir->save()) {


                foreach ($request->cart as $cart) {
                    $productIsExist = $avoir->avoir_detaille()->where('produit_id',$cart['id'])->first();
                    logger($productIsExist);
                    if($productIsExist){
                        $det = $productIsExist;
                        $hangeproduit = -$det->quantite + $cart['quantite'];
                        $qtyold = $det->quantite;
                        $det->avoir_id = $avoir->id;
                        $det->produit_id = $cart['id'];
                        $det->quantite = $cart['quantite'];
                        $det->x = $cart['x']; //twli prix vente
                        $det->comme = 'rr';
                        $det->nom = $cart['nom'];
                        $det->prixvents = $cart['prixvents'];
                        $det->prixun = 22;
                        $det->save();
                        $produit=produit::where('id',$det->produit_id)->first();
                        $produit->stock+= $hangeproduit;
                        $produit->save(); 
                            //stock
                            $stock= new stock();
                            $stock->user_id=Auth()->user()->id;
                            $stock->produit_id= $produit->id;
                            $stock->mouvement_id=1;//
                            $stock->qty = $cart['quantite'];
                            $stock->save();
                            $stock2= new stock();
                            $stock2->user_id=Auth()->user()->id;
                            $stock2->produit_id= $produit->id;
                            $stock2->mouvement_id=2;//
                            $stock2->qty = $qtyold;
                            $stock2->save();
                        
                          
                    
                    }else{
                        $avoir->avoir_detaille()->create([
                            'produit_id' => $cart['id'],
                            'quantite' => $cart['quantite'],
                            'x' => $cart['x'],
                            'comme' => 'ddd',
                            'nom' => $cart['nom'],
                            'prixvents' => $cart['prixvents'],
                            'prixun' => 22,
                        ]);
                        $produit = produit::where('id', $cart['id'])->first();
                        $produit->stock -= $cart['quantite'];
    
                        $produit->save();
    
                        $stock = new stock();
                        $stock->user_id = Auth()->user()->id;
                        $stock->produit_id = $produit->id;
                        $stock->mouvement_id = 2; //
                        $stock->qty = $cart['quantite'];
                        $stock->save();     
                   

              
                    }      
                }                
            }
        }
    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\avoir  $avoir
     * @return \Illuminate\Http\Response
     */
    public function edit(avoir $avoir)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\avoir  $avoir
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, avoir $avoir)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\avoir  $avoir
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $avoir = avoir::where('id', $id)->first();
       
        //trasabilite
   $hystorique_factur= new hystorique_factur();
   $hystorique_factur->facture_id = $avoir->id;
   $hystorique_factur->user_id=Auth()->user()->id;
   $hystorique_factur->catfacture_id=3; // 1 cree 2 modifier 3supprimer;
   $hystorique_factur->typecasse_id=2;// 1 vente 2 avoir 3reglement 4 achat 5 commande 6 devis;
   $hystorique_factur->save();



        $avoir_detaille = avoir_detaille::where('avoir_id', $avoir->id)->get();
        
        foreach ($avoir_detaille as $det) {

            $produit = produit::where('id', $det->produit_id)->first();
            $produit->stock -= $det->quantite;
            $produit->save();
            $stock2 = new stock();
            $stock2->user_id = Auth()->user()->id;
            $stock2->produit_id = $produit->id;
            $stock2->mouvement_id = 2; //
            $stock2->qty = $det->quantite;
            $stock2->save();
        }
       foreach ($avoir_detaille as $det) {
            $det->delete();
        }
        $avoir->delete();

        //supprime caisse
        $caisse=caisse::where('typecasse_id', 2)
        ->where('entrer_id', $avoir->id)
        ->first();
        if($caisse){
        $caisse->delete();}
 
        return redirect()->back()->with('success', ' bien supprimer');
    }
    
}
