<?php

namespace App\Http\Controllers;
use App\Models\depense;
use App\Models\caisse;
use Illuminate\Support\Carbon;
use Illuminate\Http\Request;

class CaisseController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $startDate = $request->input('start_date');
        $endDate = $request->input('end_date');
    
        // Filtrer les données si les dates sont fournies
        $queryCaisse = caisse::query();
        $queryDepense = depense::query();
    
        if ($startDate && $endDate) {
            $queryCaisse->whereBetween('created_at', [$startDate, $endDate]);
            $queryDepense->whereBetween('created_at', [$startDate, $endDate]);
        }
    
        // Pagination
        $caisse = $queryCaisse->orderBy('created_at', 'desc')->paginate(10); // 10 éléments par page
        $depenses = $queryDepense->orderBy('created_at', 'desc')->paginate(10);
    
        // Calcul des totaux
        $sumcaisse = $queryCaisse->sum('montant');
        $sumdepense = $queryDepense->sum('prix');
    
        // Retourner la vue avec les données
        return view('admin.caissebl', compact('caisse', 'depenses', 'sumcaisse', 'sumdepense'));
    }
    
   

   

    public function chercherParDate(Request $request)
    {
        $startDate = $request->input('start_date');
        $endDate = $request->input('end_date');
    
        // Ajuster les heures si les dates sont les mêmes
        if ($startDate && $endDate) {
            $startDate = Carbon::parse($startDate)->startOfDay(); // Début du jour
            $endDate = Carbon::parse($endDate)->endOfDay();       // Fin du jour
        }
    
        // Requête conditionnelle si des dates sont fournies
        $queryCaisse = caisse::query();
        $queryDepense = depense::query();
    
        if ($startDate && $endDate) {
            $queryCaisse->whereBetween('created_at', [$startDate, $endDate]);
            $queryDepense->whereBetween('created_at', [$startDate, $endDate]);
        }
    
        // Pagination
        $caisse = $queryCaisse->orderBy('created_at', 'desc')->paginate(10);
        $depenses = $queryDepense->orderBy('created_at', 'desc')->paginate(10);
    
        // Calcul des totaux
        $sumcaisse = $queryCaisse->sum('montant');
        $sumdepense = $queryDepense->sum('prix');
    
        return view('admin.caissebl', compact('caisse', 'depenses', 'sumcaisse', 'sumdepense', 'startDate', 'endDate'));
    }
    
    
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
       
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\caisse  $caisse
     * @return \Illuminate\Http\Response
     */
    public function show(caisse $caisse)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\caisse  $caisse
     * @return \Illuminate\Http\Response
     */
    public function edit(caisse $caisse)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\caisse  $caisse
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, caisse $caisse)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\caisse  $caisse
     * @return \Illuminate\Http\Response
     */
    public function destcaisse($id)
    {
        $caisse=caisse::where('id', $id)->first();
        $caisse->delete();
    }
}
