<?php

namespace App\Http\Controllers;
use App\Models\detaille_devis;
use App\Models\devis;
use Illuminate\Http\Request;
use \Carbon\Carbon;
use App\Models\hystorique_factur;
class DevisController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('admin.devis');
    }
    public function facturdevis()
    {
        $devis=devis::orderBy('created_at','desc')->paginate(10);
        return view('admin.facturdevis',['devis'=>$devis]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
   

        $devis= new devis();
        $devis->user_id=Auth()->user()->id;
        $devis->prixtotal=$request->prixtotal;
        $devis->client_id=$request->idclient;
        $devis->ref=22;
        $devis->prixtotal = $request->prixtotal;  
        $devis->totalTVA = $request->totaltva;
        $devis->totalavecTVA = $request->totalavecTVA;
        $devis->totalremise = $request->totalremise;
  
 
         $devis->save();
       
         if($devis->save()){
            foreach ($request->cart as $item) {

                $detaille_devis = new detaille_devis();
                $detaille_devis->devis_id = $devis->id;
                $detaille_devis->desc = $item['desc'];
                $detaille_devis->quantite = $item['quantite'];
                $detaille_devis->prix_vente = $item['prixvente'];
          
                $detaille_devis->total = $item['total'];
             
            
           
                $detaille_devis->save();

               
        
            
           
             
      

           
                   
        }
            
              
         }
       

        return redirect()->back()->with('success', ' bien enregistrer');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\devis  $devis
     * @return \Illuminate\Http\Response
     */
    public function show(devis $devis)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\devis  $devis
     * @return \Illuminate\Http\Response
     */
    public function edit(devis $devis)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\devis  $devis
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, devis $devis)
    {
        //
    }
    public function genererNumeroFacture()
    {
        // Récupérer le dernier ID dans la table 'vente'
        $dernierId = devis::max('id');
    
        // Calculer le prochain ID
        $prochainId = $dernierId ? $dernierId + 1 : 1;
    
        // Générer le numéro de facture adapté
        $numeroFacture = $prochainId;
    
        // Retourner une réponse JSON
        return response()->json([
            'success' => true,
            'numero_facture' => $numeroFacture,
        ]);
    }
    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\devis  $devis
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $devis = devis::where('id', $id)->first();
       
      
        $detaille_devis = detaille_devis::where('devis_id', $devis->id)->get();
        
       foreach ($detaille_devis as $det) {
            $det->delete();
        }
        $devis->delete();

   
 
        return redirect()->back()->with('success', ' bien supprimer');
    }
}
