<?php

namespace App\Http\Controllers;
use App\Models\produit;
use App\Models\stock;
use App\Models\lieustock;
use App\Models\mouvement;
use Illuminate\Http\Request;

class StockController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $lieustock=lieustock::all();
        $mouvements=mouvement::all();
        $stocks=stock::orderBy('created_at','desc')->paginate(10); 
        $produits= produit::all();
        return view('admin.stock',['produits'=>$produits,
        'stocks'=>$stocks,
        'lieustock'=>$lieustock,
        'mouvements'=>$mouvements
    ]);
    }
    public function lieustock()
    {
        $lieustock=lieustock::all();
 
        return response()->json(['lieustock'=>$lieustock]);
    }
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function entrer(Request $request,$id)
    {
       
        $stocks = Stock::where('produit_id', $id)
        ->where('mouvement_id', 1)
        ->paginate(10); // 10 éléments par page
    
    return view('admin.entrer', ['stocks' => $stocks]);
    
      
    }
    public function sortie(Request $request,$id)
    {
        $stocks = Stock::where('produit_id', $id)
        ->where('mouvement_id',2)
        ->paginate(10); // 10 éléments par page
    
    return view('admin.sortie', ['stocks' => $stocks]);
    
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $stock= new stock();
        $stock->user_id=Auth()->user()->id;
     $produit=produit::where('id',$request->produit)->first();
        $stock->produit_id=$request->produit;
        $stock->qty=$request->qty;
      
        $stock->mouvement_id=$request->mouvement;
        $stock->save();
       if ($stock->save()){
  if($request->mouvement==1){
    $produit->stock+=$request->qty;
  }elseif($request->mouvement==2){
    $produit->stock-=$request->qty;
  }
$produit->save();
       }
        return redirect()->back()->with('success', ' bien enregistrer');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\stock  $stock
     * @return \Illuminate\Http\Response
     */
    public function show(stock $stock)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\stock  $stock
     * @return \Illuminate\Http\Response
     */
    public function edit(stock $stock)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\stock  $stock
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, stock $stock)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\stock  $stock
     * @return \Illuminate\Http\Response
     */
    public function destroy(stock $stock)
    {
        //
    }
}
