<?php

namespace App\Http\Controllers;

use App\Models\Topcat;
use App\Models\lieustock;
use Illuminate\Http\Request;

class TopcatController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function topcat()
    {
        $topcats= Topcat::all();
 
        return response()->json(['topcats'=>$topcats]);
    }
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
       
        $topcats= Topcat::withCount('produit')->paginate(10); // Récupérer 10 produits par page
    
        $lieustock=lieustock::all();
        return view('admin.topcat1',[
            'lieustock'=>$lieustock,
            'topcats'=>$topcats
        ]);
    }


    public function searchecat(Request $request)
    {
        // Récupérer tous les lieux de stockage
        $lieustock = lieustock::all();
    
        // Récupérer la valeur de query depuis la requête (ou une chaîne vide par défaut)
        $query = $request->input('search');
    
        // Effectuer la recherche sur le modèle Topcat
        $topcats = Topcat::withCount('produit')
            ->where('topcat', 'like', "%{$query}%")
            ->paginate(10); // Limitez les résultats à 10 par page
    
        // Retourner les données à la vue
        return view('admin.topcat1', compact('lieustock', 'topcats'));
    }
    
    


    

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
     
        $imageName='';
        if($request->hasFile('image')){
        $imageName = time().'.'.$request->image->getClientOriginalExtension();  
     
        $request->image->move(public_path('img'), $imageName);
        }
     
        $topcat= new Topcat();
        $topcat->topcat=$request->topcat;
        $topcat->lieustock_id=1;
        $topcat->img=$imageName;
        $topcat->save();
        return redirect()->back()->with('success', ' bien enregistrer');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Topcat  $topcat
     * @return \Illuminate\Http\Response
     */
    public function show(Topcat $topcat)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Topcat  $topcat
     * @return \Illuminate\Http\Response
     */
 
        public function topcatbyid( $id)
        {
            $topcats= Topcat::where('lieustock_id',$id)->get();
     
            return response()->json(['topcats'=>$topcats]);
        }
    
  

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Topcat  $topcat
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        
//dd($request->all());
$imageName='';
if($request->hasFile('image')){
$imageName = time().'.'.$request->image->getClientOriginalExtension();  

$request->image->move(public_path('img'), $imageName);
$Topcat=Topcat::where('id',$id)->first();
$Topcat->topcat=$request->input('topcat');
$Topcat->lieustock_id=$request->input('lieu');
$Topcat->img=$imageName;
$Topcat->save();
return redirect()->back()->with('success', ' bien modifier');

}else{
        $Topcat=Topcat::where('id',$id)->first();
        $Topcat->topcat=$request->input('topcat');
        $Topcat->lieustock_id=$request->input('lieu');
        $Topcat->save();
        return redirect()->back()->with('success', ' bien modifier');

}


   


    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Topcat  $topcat
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
   
        $Topcat=Topcat::where('id',$id)->first();
    $Topcat->delete();
    return redirect()->back()->with('success', ' bien supprimer');

}
}
