<?php

namespace App\Http\Controllers;

use App\Models\produit;
use App\Models\stock;
use App\Models\info;
use App\Models\ville;
use App\Models\statut;
use App\Models\encour;
use App\Models\vente;
use App\Models\client;
use App\Models\catclientfrn;
use App\Models\enattend;
use App\Models\caisse;
use App\Models\detaille_bonlivraison;
use App\Models\bonlivraison;
use App\Models\detaille_vente;
use App\Models\hystoriqprix;
use App\Models\cheque;
use App\Models\detaille_enattend;
use Barryvdh\DomPDF\Facade\Pdf;
use Illuminate\Http\Request;
use \Carbon\Carbon;
use Illuminate\Support\Facades\DB;

class VenteController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function adminpdf()
    {





        $pdf = PDF::loadView('admin.chart')->setOptions(['defaultFont' => 'sans-serif']);
        // $pdf = PDF::loadView('chart',['facture'=>$facture,'infoadmin'=>$infoadmin])->setOptions(['defaultFont' => 'sans-serif']);

        return $pdf->download('facturepdf.pdf');
    }
    public function index()
    {

        $clients = client::all();
        $villes = ville::all();
        $statuts = statut::all();
        $catclientfrns = catclientfrn::all();
        return view('admin.vente', [

            'clients' => $clients,
            'villes' => $villes,
            'statcatclientfrnsuts' => $catclientfrns,
            'statuts' => $statuts,
        ]);
    }
    public function all_ventes()
    {
        $enattend = enattend::all();
        $encour = encour::all();
        $clients = client::all();
        $villes = ville::all();
        $statuts = statut::all();
        $catclientfrns = catclientfrn::all();
        $ventes = vente::all();
        $ventes_encour = vente::where('encour_id', 2)->get();
        $ventes_payer = vente::where('encour_id', 1)->get();
        $ventes_enatted = vente::where('bonenattentsituation_id', 1)->get();
        $ventes_urgent = vente::where('crediiturgent_id', 2)->get();
        return view('admin.all_ventes', [

            'clients' => $clients,
            'villes' => $villes,
            'statcatclientfrnsuts' => $catclientfrns,
            'statuts' => $statuts,
            'ventes' => $ventes,
            'encour' => $encour,

            'enattend' => $enattend,
            'ventes_encour' => $ventes_encour,
            'ventes_payer' => $ventes_payer,
            'ventes_enatted' => $ventes_enatted,
            'ventes_urgent' => $ventes_urgent,




        ]);
    }
    public function facturvente()
    {
        $encour = encour::all();
        $ventes = vente::all();
        return view('admin.facturvente', ['ventes' => $ventes, 'encour' => $encour]);
    }
    public function detaillefacturvente($id)
    {
        $info = info::all();
        $encour = encour::all();
        $ventes = vente::where('id', $id)->first();
        return view('admin.facturedetaille', ['ventes' => $ventes, 'encour' => $encour, 'info' => $info]);
    }
    public function bonlivraison()
    {
        $encour = encour::all();
        $bonlivraisons = bonlivraison::all();
        return view('admin.bonlivraison', ['bonlivraisons' => $bonlivraisons, 'encour' => $encour]);
    }
    public function reglementclient()
    {
        $clients = client::all();
        $encour = encour::all();
        $ventes = vente::where('encour_id', 2)->get();
        return view('admin.reglclient', ['ventes' => $ventes, 'encour' => $encour, 'clients' => $clients]);
    }

    public function reglementclient_all()
    {

        $encour = encour::all();
        $ventes = vente::where('encour_id', 2)->get();
        return view('admin.reglementclient_all', ['ventes' => $ventes, 'encour' => $encour]);
    }
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function blenatted()
    {

        $ventes = vente::where('bonenattentsituation_id', 1)->get();
        return view('admin.blenatted', ['ventes' => $ventes]);
    }
    public function blconfirme()
    {
        $ventes = vente::where('bonenattentsituation_id', 2)->get();
        return view('admin.blconfirme', ['ventes' => $ventes]);
    }

    public function blurgent()
    {

        $ventes = vente::where('crediiturgent_id', 2)->get();
        return view('admin.blurgent', ['ventes' => $ventes]);
    }
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        if ($request->bonstatut == 1) {
            $enattend = new enattend();
            $enattend->user_id = Auth()->user()->id;
            $enattend->prixtotal = $request->prixtotal;
            $enattend->client_id = $request->client;
            $enattend->modepayement_id = $request->idmod;
            $enattend->dateecheance = Carbon::now();
            $enattend->lieustock_id = $request->idlieutoock;
            $enattend->comment = $request->comment;
            $enattend->transporteur = $request->transporteur;
            $enattend->encour_id = 2; //credit
            $enattend->avance = $request->avance;
            $enattend->rest = $request->prixtotal - $request->avance;




            $enattend->bonenattentsituation_id = $request->bonstatut;
            $enattend->crediiturgent_id = $request->crediturgent;

            $enattend->activebutton_id = 1; //achnou hadi?
            $enattend->remise = $request->remise;
            $enattend->save();



            foreach ($request->cart as $req => $key) {

                $detaille_enattend = new detaille_enattend();
                $detaille_enattend->enattend_id = $enattend->id;
                $detaille_enattend->produit_id = $request->cart[$req]['id'];
                $detaille_enattend->qty = $request->cart[$req]['quantite'];
                $detaille_enattend->total = $request->cart[$req]['x']; //twli prix vente
                $detaille_enattend->comment = $request->cart[$req]['comme'];
                $detaille_enattend->prixvente = $request->cart[$req]['prixvents'];
                $detaille_enattend->save();
            }
            return response()->json(['enattend' => $enattend]);
        } elseif ($request->bonstatut == 2) {




            $vente = new vente();
            $vente->user_id = Auth()->user()->id;
            $vente->prixtotal = $request->prixtotal;
            $vente->client_id = $request->client;
            $vente->modepayement_id = $request->idmod;
            $vente->dateecheance = Carbon::now();
            $vente->lieustock_id = $request->idlieutoock;
            $vente->comment = $request->comment;
            $vente->transporteur = $request->transporteur;
            if ($request->bonstatut == 1) {
                $vente->encour_id = 2; //espece
            } elseif ($request->bonstatut == 2) {
                $vente->encour_id = 1; //espece
            }
            $vente->bonenattentsituation_id = $request->bonstatut;
            $vente->crediiturgent_id = $request->crediturgent;

            $vente->activebutton_id = 1; //achnou hadi?
            $vente->remise = $request->remise;
            if ($request->idmod == 2) {
                $vente->encour_id = 2; //credit
                $vente->avance = $request->avance;
                $vente->rest = $request->prixtotal - $request->avance;
                $vente->crediiturgent_id = $request->crediturgent;
            }
            if ($request->idmod == 1) {
                $vente->avance = 0;
            }
            if ($request->idmod == 5) {
                $vente->encour_id = 2;
                $vente->chequepart = $request->chequepart;
                $vente->especepart = $request->especepart;
            }
            $vente->save();

            if ($vente->save()) {

                foreach ($request->cart as $req => $key) {

                    $detaille_vente = new detaille_vente();
                    $detaille_vente->vente_id = $vente->id;
                    $detaille_vente->produit_id = $request->cart[$req]['id'];
                    $detaille_vente->quantite = $request->cart[$req]['quantite'];
                    $detaille_vente->x = $request->cart[$req]['x']; //twli prix vente
                    $detaille_vente->comme = $request->cart[$req]['comme'];
                    $detaille_vente->nom = $request->cart[$req]['nom'];
                    $detaille_vente->prixvents = $request->cart[$req]['prixvents'];
                    $detaille_vente->prixun = $request->cart[$req]['prixun'];
                    $detaille_vente->save();







                    $produit = produit::where('id', $request->cart[$req]['id'])->first();
                    $produit->stock -= $request->cart[$req]['quantite'];

                    $produit->save();

                    $stock = new stock();
                    $stock->user_id = Auth()->user()->id;
                    $stock->produit_id = $produit->id;
                    $stock->mouvement_id = 2; //
                    $stock->qty = $request->cart[$req]['quantite'];
                    $stock->save();







                    //hystorique



                    $hystoriqprix = new hystoriqprix();

                    $hystoriqprix->produit_id = $produit->id;
                    $hystoriqprix->client_id = $request->client;
                    $hystoriqprix->prixvente = $request->cart[$req]['prixvents'];
                    $hystoriqprix->save();
                }
            }
        }

        if ($request->idmod == 3) {
            $vente->rest = 0;
            $cheque = new cheque();
            $cheque->client_id = $request->client;
            $cheque->vente_id = $vente->id;
            $cheque->numero = $request->numero;
            $cheque->boonque = $request->boonque;
            $cheque->montant = $request->prixtotal;
            $cheque->date = $request->date;
            $cheque->save();
        }
        if ($request->idmod == 5) {

            $cheque = new cheque();
            $cheque->client_id = $request->client;
            $cheque->vente_id = $vente->id;
            $cheque->numero = $request->numero;
            $cheque->boonque = $request->boonque;
            $cheque->montant = $request->chequepart;
            $cheque->date = $request->date;
            $cheque->save();
        }

        if ($request->idmod !== 2) {
            $caisse = new caisse();
            $caisse->entrer = $request->prixtotal;
            $caisse->srtie = 0;
            $caisse->justif = "vente facture n:" . $vente->id;
            $caisse->save();
        } elseif ($request->idmod == 2) {
            $caisse = new caisse();
            $caisse->entrer = $request->avance;
            $caisse->srtie = 0;
            $caisse->justif = "avance facture n:" . $vente->id;
            $caisse->save();

            $client = client::where('id', $request->client)->first();
            $client->monton += $request->prixtotal - $request->avance;
            $client->save();


            $casa = vente::where('id', $vente->id)->first();
        }

        return response()->json(['vente' => $vente]);
    }

    public function storebonmivraison(Request $request)
    {

/*
        $bonlivraison = new bonlivraison();
        $bonlivraison->user_id = Auth()->user()->id;
        $bonlivraison->ref_vente = $vente->id;
        $bonlivraison->prixtotal = $request->prixtotal;
        $bonlivraison->client_id = $request->client;
        // $bonlivraison->modepayement_id=$request->idmod;
        $bonlivraison->dateecheance = $request->dateecheance;
        $bonlivraison->lieustock_id = 1;

        $bonlivraison->encour_id = 1; //espece
        $bonlivraison->avance = $request->prixtotal;
        $bonlivraison->rest = 0;

        $bonlivraison->save();

        if ($bonlivraison->save()) {
            foreach ($request->id as $req => $key) {
                $detaille_bonlivraison = new detaille_bonlivraison();
                $detaille_bonlivraison->vente_id = $vente->id;
                $detaille_bonlivraison->produit_id = $request->id[$req];
                $detaille_bonlivraison->qty = $request->qty[$req];
                $detaille_bonlivraison->total = 22; //twli prix vente
                $detaille_bonlivraison->save();
            }
        }*/
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\vente  $vente
     * @return \Illuminate\Http\Response
     */
    public function moodifvente(Request $request, $id)
    {

        $vente = vente::where('id', $id)->first();
        $vente->bonenattentsituation_id = 2;
        $vente->save();
        $detaille_vente = detaille_vente::where('vente_id', $request->id)->get();
        $products_ids = $detaille_vente->pluck('produit_id')->toArray();

        $products = produit::whereIn('id', $products_ids)->get();

        foreach ($detaille_vente as $item) {
            $product = $products->where('id', $item->produit_id)->first();
            $new_stock = $product->stock - $item->qty;
            produit::where('id', $item->produit_id)->update(['stock' => $new_stock]);
        }



        /*
    $stock= new stock();
    $stock->user_id=Auth()->user()->id;
    $stock->produit_id=  $item->produit_id;
    $stock->mouvement_id=2;
    $stock->qty =$item->qty ;
    $stock->save();




  



    $caisse= new caisse();
$caisse->entrer=$request->prixtotal;
$caisse->srtie=0;
$caisse->justif="vente facture n 20";
$caisse->save();

*/




        return redirect()->back()->with('success', ' bien enregistrer');
    }

    public function modifier_vente(Request $request, $id)
    {
        $vente = vente::where('id', $id)->first();
        $olderest = $vente->rest;
        $esto = $request->prixtotal - $request->avance;
        $vente->user_id = Auth()->user()->id;
        $vente->prixtotal = $request->prixtotal;
        $vente->client_id = $request->client;
        $vente->modepayement_id = $request->idmod;
        $vente->dateecheance = Carbon::now();
        $vente->lieustock_id = $request->idlieutoock;
        $vente->comment = $request->comment;
        $vente->transporteur = $request->transporteur;

        if ($request->bonstatut == 2) {
            switch ($request->idmod) {
                case 1:
                    //supprim cheque
                    $cheque =   cheque::where('vente_id', $vente->id)->first();
                    if ($cheque) {
                        $cheque->delete();
                    }
                    //regle client  espece vercement
                    $client1 = client::where('id', $request->client)->first();
                    $client1->monton -= $vente->rest;
                    $client1->save();

                    $caisse = new caisse();
                    $caisse->entrer = $request->prixtotal;
                    $caisse->srtie = $vente->prixtotal;
                    $caisse->justif = "mdifier facture n:" . $vente->id;
                    $caisse->save();
                    $vente->rest = 0; //hada dima ltht
                    $vente->avance = 0;
                    $vente->encour_id = 1; //payer
                    break;
                case 2:
                    //supprim cheque
                    $cheque =   cheque::where('vente_id', $vente->id)->first();
                    if ($cheque) {
                        $cheque->delete();
                    }
                    $vente->rest = $request->prixtotal - $request->avance;
                    $vente->avance = $request->avance;
                    //regle client
                    $client = client::where('id', $request->client)->first();
                    $client->monton += $esto;
                    $client->save();
                    $caisse = new caisse();
                    $caisse->entrer = $request->avance;
                    $caisse->srtie = $vente->avance;
                    $caisse->justif = "modiifier facture n:" . $vente->id;
                    $caisse->save();
                    $vente->encour_id = 2; //credit
                    break;
                case 3:

                    //regle client  espece vercement
                    $client1 = client::where('id', $request->client)->first();
                    $client1->monton -= $vente->rest;
                    $client1->save();
                    $vente->rest = 0; //hada dima ltht
                    $vente->avance = 0;
                    $cheque =   cheque::where('vente_id', $vente->id)->first();
                    if ($cheque) {
                        $cheque->client_id = $request->client;
                        $cheque->vente_id = $vente->id;
                        $cheque->numero = $request->numero;
                        $cheque->boonque = $request->boonque;
                        $cheque->montant = $request->prixtotal;
                        $cheque->date = $request->date;
                        $cheque->save();
                    } else {
                        $cheque1 = new cheque();
                        $cheque1->client_id = $request->client;
                        $cheque1->vente_id = $vente->id;
                        $cheque1->numero = $request->numero;
                        $cheque1->boonque = $request->boonque;
                        $cheque1->montant = $request->prixtotal;
                        $cheque1->date = $request->date;
                        $cheque1->save();
                    }
                    $caisse = new caisse();
                    $caisse->entrer = $request->prixtotal;
                    $caisse->srtie = $vente->prixtotal;
                    $caisse->justif = "mdifier facture n:" . $vente->id;
                    $vente->encour_id = 1; //payer
                    break;
                case 4:
                    $cheque =   cheque::where('vente_id', $vente->id)->first();
                    if ($cheque) {
                        $cheque->delete();
                    }

                    //regle client  espece vercement
                    $client1 = client::where('id', $request->client)->first();
                    $client1->monton -= $vente->rest;
                    $client1->save();
                    $vente->rest = 0; //hada dima ltht
                    $vente->avance = 0;
                    $caisse = new caisse();
                    $caisse->entrer = $request->prixtotal;
                    $caisse->srtie = $vente->prixtotal;
                    $caisse->justif = "mdifier facture n:" . $vente->id;
                    $vente->encour_id = 1; //payer
                    break;
                case 5:
                    dd('5');
                    break;
            }
            $vente->save();
            //modfier cart
            if ($vente->save()) {




                $detaille_vente = detaille_vente::where('vente_id', $vente->id)->get();
                foreach ($detaille_vente as $det) {

                    foreach ($request->cart as $req => $key) {

                        if ($request->cart[$req]['id'] == $det->produit_id) {
                            $hangeproduit = - $det->quantite +$request->cart[$req]['quantite']; 
                            $qtyold=$det->quantite;
                            $det->vente_id = $vente->id;
                            $det->produit_id = $request->cart[$req]['id'];
                            $det->quantite = $request->cart[$req]['quantite'];
                            $det->x = $request->cart[$req]['x']; //twli prix vente
                            $det->comme = 'rr';
                            $det->nom = $request->cart[$req]['nom'];
                            $det->prixvents = $request->cart[$req]['prixvents'];
                            $det->prixun = 22;

                            $det->save();
                            $produit=produit::where('id',$det->produit_id)->first();
                            $produit->stock-= $hangeproduit;
                            $produit->save(); 
                                //stock
                                $stock= new stock();
                                $stock->user_id=Auth()->user()->id;
                                $stock->produit_id= $produit->id;
                                $stock->mouvement_id=2;//
                                $stock->qty = $request->cart[$req]['quantite'];
                                $stock->save();
                                $stock2= new stock();
                                $stock2->user_id=Auth()->user()->id;
                                $stock2->produit_id= $produit->id;
                                $stock2->mouvement_id=1;//
                                $stock2->qty = $qtyold;
                                $stock2->save();
                            
                              
                            
                                    $hystoriqprix= new hystoriqprix();
                                    
                                    $hystoriqprix->produit_id= $produit->id;
                                    $hystoriqprix->client_id=$request->client;
                                    $hystoriqprix->prixvente=$request->cart[$req]['prixvents'];
                                    $hystoriqprix->save();
                        } else {
                            $new_model = detaille_vente::create([
                                'vente_id' => $vente->id,
                                'produit_id' => $request->cart[$req]['id'],
                                'quantite' => $request->cart[$req]['quantite'],
                                'x' => $request->cart[$req]['x'],
                                'comme' => 'ddd',
                                'nom' => $request->cart[$req]['nom'],
                                'prixvents' => $request->cart[$req]['prixvents'],
                                'prixun' => 22,
                            ]);
                            logger($new_model);

                            $produit = produit::where('id', $request->cart[$req]['id'])->first();
                            $produit->stock -= $request->cart[$req]['quantite'];
        
                            $produit->save();
        
                            $stock = new stock();
                            $stock->user_id = Auth()->user()->id;
                            $stock->produit_id = $produit->id;
                            $stock->mouvement_id = 2; //
                            $stock->qty = $request->cart[$req]['quantite'];
                            $stock->save();     
                            $hystoriqprix = new hystoriqprix();

                            $hystoriqprix->produit_id = $produit->id;
                            $hystoriqprix->client_id = $request->client;
                            $hystoriqprix->prixvente = $request->cart[$req]['prixvents'];
                            $hystoriqprix->save();
                        }
                    }
                }
            }
            //fin modifiier cart











            //fin hna dir back();
        } elseif ($request->bonstatut == 1) {
            dd('attaend');
        }




        return back();
    }












    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\vente  $vente
     * @return \Illuminate\Http\Response
     */

    function date_vente(Request $request)
    {
        // dd($request->all());
        $enattend = enattend::whereBetween('created_at', [$request->debut, $request->fin])
            ->get();
        $encour = encour::all();
        $clients = client::all();
        $villes = ville::all();
        $statuts = statut::all();
        $catclientfrns = catclientfrn::all();
        $ventes = vente::whereBetween('created_at', [$request->debut, $request->fin])
            ->get();
        $ventes_encour = vente::where('encour_id', 2)->whereBetween('created_at', [$request->debut, $request->fin])
            ->get();
        $ventes_payer = vente::where('encour_id', 1)->whereBetween('created_at', [$request->debut, $request->fin])
            ->get();
        $ventes_enatted = vente::where('bonenattentsituation_id', 1)->whereBetween('created_at', [$request->debut, $request->fin])
            ->get();
        $ventes_urgent = vente::where('crediiturgent_id', 2)->whereBetween('created_at', [$request->debut, $request->fin])
            ->get();
        return view('admin.all_ventes', [

            'clients' => $clients,
            'villes' => $villes,
            'statcatclientfrnsuts' => $catclientfrns,
            'statuts' => $statuts,
            'ventes' => $ventes,
            'encour' => $encour,

            'enattend' => $enattend,
            'ventes_encour' => $ventes_encour,
            'ventes_payer' => $ventes_payer,
            'ventes_enatted' => $ventes_enatted,
            'ventes_urgent' => $ventes_urgent,




        ]);
    }
    public function edit(vente $vente)
    {
        //
    }
    public function lastid()
    {
        $lasid = vente::latest('id')->first();
        return response()->json(['lasid' => $lasid]);
    }
    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\vente  $vente
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, vente $vente)
    {
        //
    }
    public function modifevente(Request $request, $id)
    {
        $ventes = vente::where('id', $id)->first();
        $detaille_vente = detaille_vente::where('vente_id', $id)->get();

        return view('admin.modifevente', ['ventes' => $ventes, 'detaille_vente' => $detaille_vente]);
    }
    public function modifevente2(Request $request)
    {

        $id = $request->idvente;
        $ventes = vente::where('id', $id)->first();
        $detaille_vente = detaille_vente::where('vente_id', $id)->get();
        return view('admin.modifevente', ['ventes' => $ventes, 'detaille_vente' => $detaille_vente]);
    }

    public function modifeventejson($id)
    {
        $ventes = vente::where('id', $id)->first();
        $detaille_vente = detaille_vente::where('vente_id', $id)->with('produit')->get();


        return response()->json(['ventes' => $ventes, 'detaille_vente' => $detaille_vente]);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\vente  $vente
     * @return \Illuminate\Http\Response
     */

    public function reglevente(Request $request)
    {
        $data = $request->ids;

        foreach ($data  as $req => $key) {

            $vente = vente::where('id', $data[$req])->first();
            //caisse
            $caisse = new caisse();
            $caisse->entrer = $vente->rest;
            $caisse->srtie = 0;
            $caisse->justif = "reglement client n:" . $vente->id;
            $caisse->save();

            //caisse
            $client = client::where('id', $vente->client_id)->first();

            $client->monton -= $vente->rest;

            $client->save();




            $vente->rest;
            $vente->rest = 0;
            $vente->avance = $vente->prixtotal;
            $vente->encour_id = 1;
            $vente->save();




            //client
        }



        return back();
    }

    public function destroy($id)
    {

        $vente = vente::where('id', $id)->first();


        //regle caisse
        if ($vente->modepayement_id == 2) { //2credit
            $client = client::where('id', $vente->client_id)->first();
            $client->monton -= $vente->rest;
            $client->save();

            $caisse = new caisse();
            $caisse->entrer = 0;
            $caisse->srtie = $vente->avance;

            $caisse->justif = "supriimer facture n:" . $vente->id;
            $caisse->save();
        }
        if ($vente->modepayement_id == 1 or $vente->modepayement_id == 4) { //1 espece

            $caisse = new caisse();
            $caisse->entrer = 0;
            $caisse->srtie = $vente->prixtotal;

            $caisse->justif = "supriimer facture n:" . $vente->id;
            $caisse->save();
        }

        if ($vente->modepayement_id == 3) { //1 espece
            $cheque = cheque::where('vente_id', $vente->id)->first();
            $cheque->delete();
            $caisse = new caisse();
            $caisse->entrer = 0;
            $caisse->srtie = $vente->prixtotal;

            $caisse->justif = "supriimer facture n:" . $vente->id;
            $caisse->save();
        }

        if ($vente->modepayement_id == 5) { //1 espece
            $cheque = cheque::where('vente_id', $vente->id)->first();
            $cheque->delete();
            $caisse = new caisse();
            $caisse->entrer = 0;
            $caisse->srtie = $vente->prixtotal;

            $caisse->justif = "supriimer facture n:" . $vente->id;
            $caisse->save();
        }
        $detaille_vente = detaille_vente::where('vente_id', $vente->id)->get();
        foreach ($detaille_vente as $det) {

            $produit = produit::where('id', $det->produit_id)->first();
            $produit->stock += $det->quantite;
            $produit->save();
            $stock2 = new stock();
            $stock2->user_id = Auth()->user()->id;
            $stock2->produit_id = $produit->id;
            $stock2->mouvement_id = 1; //
            $stock2->qty = $det->quantite;
            $stock2->save();
        }
        foreach ($detaille_vente as $det) {
            $det->delete();
        }
        $vente->delete();

        return redirect()->back()->with('success', ' bien supprimer');
    }
}
//v2

<?php

namespace App\Http\Controllers;
use App\Models\depense;
use App\Models\produit;
use App\Models\stock;
use App\Models\info;
use App\Models\ville;
use App\Models\statut;
use App\Models\encour;
use App\Models\vente;
use App\Models\client;
use App\Models\catclientfrn;
use App\Models\enattend;
use App\Models\caisse;
use App\Models\detaille_bonlivraison;
use App\Models\bonlivraison;
use App\Models\detaille_vente;
use App\Models\hystoriqprix;
use App\Models\cheque;
use App\Models\detaille_enattend;
use Barryvdh\DomPDF\Facade\Pdf;
use Illuminate\Http\Request;
use \Carbon\Carbon;
use Illuminate\Support\Facades\DB;

class VenteController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function adminpdf()
    {





        $pdf = PDF::loadView('admin.chart')->setOptions(['defaultFont' => 'sans-serif']);
        // $pdf = PDF::loadView('chart',['facture'=>$facture,'infoadmin'=>$infoadmin])->setOptions(['defaultFont' => 'sans-serif']);

        return $pdf->download('facturepdf.pdf');
    }
    public function index()
    {

        $clients = client::all();
        $villes = ville::all();
        $statuts = statut::all();
        $catclientfrns = catclientfrn::all();
        return view('admin.vente', [

            'clients' => $clients,
            'villes' => $villes,
            'statcatclientfrnsuts' => $catclientfrns,
            'statuts' => $statuts,
        ]);
    }

    public function caissebl()
    {
        $caisse=caisse::all();

       /// $ventes = vente::where('modepayement_id',1)->get();
      
        $cheques = cheque::all();
        $depenses= depense::all();
        $sumcaisse = caisse::sum('montant');
        $sumcheque = cheque::sum('montant');
        $sumdepense = depense::sum('depense');
        return view('admin.caissebl', [
            'depenses' => $depenses,
            'sumcaisse' => $sumcaisse,
            'cheques' => $cheques,
            
            'sumcheque' => $sumcheque,
            'sumdepense' => $sumdepense,
            'caisse' => $caisse,
       
        ]);
    }
    public function all_ventes()
    {
        $enattend = enattend::all();
        $encour = encour::all();
        $clients = client::all();
        $villes = ville::all();
        $statuts = statut::all();
        $catclientfrns = catclientfrn::all();
        $ventes = vente::all();
        $ventes_encour = vente::where('encour_id', 2)->get();
        $ventes_payer = vente::where('encour_id', 1)->get();
        $ventes_enatted = vente::where('bonenattentsituation_id', 1)->get();
        $ventes_urgent = vente::where('crediiturgent_id', 2)->get();
        return view('admin.all_ventes', [

            'clients' => $clients,
            'villes' => $villes,
            'statcatclientfrnsuts' => $catclientfrns,
            'statuts' => $statuts,
            'ventes' => $ventes,
            'encour' => $encour,

            'enattend' => $enattend,
            'ventes_encour' => $ventes_encour,
            'ventes_payer' => $ventes_payer,
            'ventes_enatted' => $ventes_enatted,
            'ventes_urgent' => $ventes_urgent,




        ]);
    }
    public function facturvente()
    {
        $encour = encour::all();
        $ventes = vente::all();
        return view('admin.facturvente', ['ventes' => $ventes, 'encour' => $encour]);
    }
    public function detaillefacturvente($id)
    {
        $info = info::all();
        $encour = encour::all();
        $ventes = vente::where('id', $id)->first();
        return view('admin.facturedetaille', ['ventes' => $ventes, 'encour' => $encour, 'info' => $info]);
    }
    public function bonlivraison()
    {
        $encour = encour::all();
        $bonlivraisons = bonlivraison::all();
        return view('admin.bonlivraison', ['bonlivraisons' => $bonlivraisons, 'encour' => $encour]);
    }
    public function reglementclient()
    {
        $clients = client::all();
        $encour = encour::all();
        $ventes = vente::where('encour_id', 2)->get();
        return view('admin.reglclient', ['ventes' => $ventes, 'encour' => $encour, 'clients' => $clients]);
    }

    public function reglementclient_all()
    {

        $encour = encour::all();
        $ventes = vente::where('encour_id', 2)->get();
        return view('admin.reglementclient_all', ['ventes' => $ventes, 'encour' => $encour]);
    }
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function blenatted()
    {

        $ventes = vente::where('bonenattentsituation_id', 1)->get();
        return view('admin.blenatted', ['ventes' => $ventes]);
    }
    public function blconfirme()
    {
        $ventes = vente::where('bonenattentsituation_id', 2)->get();
        return view('admin.blconfirme', ['ventes' => $ventes]);
    }

    public function blurgent()
    {

        $ventes = vente::where('crediiturgent_id', 2)->get();
        return view('admin.blurgent', ['ventes' => $ventes]);
    }
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        if ($request->bonstatut == 1) {
            $enattend = new enattend();
            $enattend->user_id = Auth()->user()->id;
            $enattend->prixtotal = $request->prixtotal;
            $enattend->client_id = $request->client;
            $enattend->modepayement_id = $request->idmod;
            $enattend->dateecheance = Carbon::now();
            $enattend->lieustock_id = $request->idlieutoock;
            $enattend->comment = $request->comment;
            $enattend->transporteur = $request->transporteur;
            $enattend->encour_id = 2; //credit
            $enattend->avance = $request->avance;
            $enattend->rest = $request->prixtotal - $request->avance;




            $enattend->bonenattentsituation_id = $request->bonstatut;
            $enattend->crediiturgent_id = $request->crediturgent;

            $enattend->activebutton_id = 1; //achnou hadi?
            $enattend->remise = $request->remise;
            $enattend->save();



            foreach ($request->cart as $req => $key) {

                $detaille_enattend = new detaille_enattend();
                $detaille_enattend->enattend_id = $enattend->id;
                $detaille_enattend->produit_id = $request->cart[$req]['id'];
                $detaille_enattend->qty = $request->cart[$req]['quantite'];
                $detaille_enattend->total = $request->cart[$req]['x']; //twli prix vente
                $detaille_enattend->comment = $request->cart[$req]['comme'];
                $detaille_enattend->prixvente = $request->cart[$req]['prixvents'];
                $detaille_enattend->save();
            }
            return response()->json(['enattend' => $enattend]);
        } elseif ($request->bonstatut == 2) {




            $vente = new vente();
            $vente->user_id = Auth()->user()->id;
            $vente->prixtotal = $request->prixtotal;
            $vente->client_id = $request->client;
            $vente->modepayement_id = $request->idmod;
            $vente->dateecheance = Carbon::now();
            $vente->lieustock_id = $request->idlieutoock;
            $vente->comment = $request->comment;
            $vente->transporteur = $request->transporteur;
            if ($request->bonstatut == 1) {
                $vente->encour_id = 2; //espece
            } elseif ($request->bonstatut == 2) {
                $vente->encour_id = 1; //espece
            }
            $vente->bonenattentsituation_id = $request->bonstatut;
            $vente->crediiturgent_id = $request->crediturgent;

            $vente->activebutton_id = 1; //achnou hadi?
            $vente->remise = $request->remise;
            if ($request->idmod == 2) {
                $vente->encour_id = 2; //credit
                $vente->avance = $request->avance;
                $vente->rest = $request->prixtotal - $request->avance;
                $vente->crediiturgent_id = $request->crediturgent;
            }
            if ($request->idmod == 1) {
                $vente->avance = 0;
            }
            if ($request->idmod == 5) {
                $vente->encour_id = 2;
                $vente->chequepart = $request->chequepart;
                $vente->especepart = $request->especepart;
            }
            $vente->save();

            if ($vente->save()) {

                foreach ($request->cart as $req => $key) {

                    $detaille_vente = new detaille_vente();
                    $detaille_vente->vente_id = $vente->id;
                    $detaille_vente->produit_id = $request->cart[$req]['id'];
                    $detaille_vente->quantite = $request->cart[$req]['quantite'];
                    $detaille_vente->x = $request->cart[$req]['x']; //twli prix vente
                    $detaille_vente->comme = $request->cart[$req]['comme'];
                    $detaille_vente->nom = $request->cart[$req]['nom'];
                    $detaille_vente->prixvents = $request->cart[$req]['prixvents'];
                    $detaille_vente->prixun = $request->cart[$req]['prixun'];
                    $detaille_vente->save();







                    $produit = produit::where('id', $request->cart[$req]['id'])->first();
                    $produit->stock -= $request->cart[$req]['quantite'];

                    $produit->save();

                    $stock = new stock();
                    $stock->user_id = Auth()->user()->id;
                    $stock->produit_id = $produit->id;
                    $stock->mouvement_id = 2; //
                    $stock->qty = $request->cart[$req]['quantite'];
                    $stock->save();







                    //hystorique



                    $hystoriqprix = new hystoriqprix();

                    $hystoriqprix->produit_id = $produit->id;
                    $hystoriqprix->client_id = $request->client;
                    $hystoriqprix->prixvente = $request->cart[$req]['prixvents'];
                    $hystoriqprix->save();
                }
            }
        }

        if ($request->idmod == 3) {
            $vente->rest = 0;
            $cheque = new cheque();
            $cheque->client_id = $request->client;
            $cheque->vente_id = $vente->id;
            $cheque->numero = $request->numero;
            $cheque->boonque = $request->boonque;
            $cheque->montant = $request->prixtotal;
            $cheque->date = $request->date;
            $cheque->save();
        }
        if ($request->idmod == 5) {

            $cheque = new cheque();
            $cheque->client_id = $request->client;
            $cheque->vente_id = $vente->id;
            $cheque->numero = $request->numero;
            $cheque->boonque = $request->boonque;
            $cheque->montant = $request->chequepart;
            $cheque->date = $request->date;
            $cheque->save();
        }

        if ($request->idmod !== 2) {
            $caisse = new caisse();
            $caisse->typecasse_id=1;
            $caisse->client_id = $request->client;
            $caisse->montant = $request->prixtotal;
            $caisse->entrer_id = $vente->id;
            $caisse->save();
        } elseif ($request->idmod == 2) {
            $caisse = new caisse();
            $caisse->typecasse_id=1;
            $caisse->client_id = $request->client;
            $caisse->montant = $request->avance;
            $caisse->entrer_id = $vente->id;
         
            $caisse->save();

            $client = client::where('id', $request->client)->first();
            $client->monton += $request->prixtotal - $request->avance;
            $client->save();


            $casa = vente::where('id', $vente->id)->first();
        }

        return response()->json(['vente' => $vente]);
    }

    public function storebonmivraison(Request $request)
    {

        /*
        $bonlivraison = new bonlivraison();
        $bonlivraison->user_id = Auth()->user()->id;
        $bonlivraison->ref_vente = $vente->id;
        $bonlivraison->prixtotal = $request->prixtotal;
        $bonlivraison->client_id = $request->client;
        // $bonlivraison->modepayement_id=$request->idmod;
        $bonlivraison->dateecheance = $request->dateecheance;
        $bonlivraison->lieustock_id = 1;

        $bonlivraison->encour_id = 1; //espece
        $bonlivraison->avance = $request->prixtotal;
        $bonlivraison->rest = 0;

        $bonlivraison->save();

        if ($bonlivraison->save()) {
            foreach ($request->id as $req => $key) {
                $detaille_bonlivraison = new detaille_bonlivraison();
                $detaille_bonlivraison->vente_id = $vente->id;
                $detaille_bonlivraison->produit_id = $request->id[$req];
                $detaille_bonlivraison->qty = $request->qty[$req];
                $detaille_bonlivraison->total = 22; //twli prix vente
                $detaille_bonlivraison->save();
            }
        }*/
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\vente  $vente
     * @return \Illuminate\Http\Response
     */
    public function moodifvente(Request $request, $id)
    {

        $vente = vente::where('id', $id)->first();
        $vente->bonenattentsituation_id = 2;
        $vente->save();
        $detaille_vente = detaille_vente::where('vente_id', $request->id)->get();
        $products_ids = $detaille_vente->pluck('produit_id')->toArray();

        $products = produit::whereIn('id', $products_ids)->get();

        foreach ($detaille_vente as $item) {
            $product = $products->where('id', $item->produit_id)->first();
            $new_stock = $product->stock - $item->qty;
            produit::where('id', $item->produit_id)->update(['stock' => $new_stock]);
        }



        /*
    $stock= new stock();
    $stock->user_id=Auth()->user()->id;
    $stock->produit_id=  $item->produit_id;
    $stock->mouvement_id=2;
    $stock->qty =$item->qty ;
    $stock->save();




  



    $caisse= new caisse();
$caisse->entrer=$request->prixtotal;
$caisse->srtie=0;
$caisse->justif="vente facture n 20";
$caisse->save();

*/




        return redirect()->back()->with('success', ' bien enregistrer');
    }

    public function modifier_vente(Request $request, $id)
    {
     
        $vente = vente::where('id', $id)->first();
        $olderest = $vente->rest;
        $esto = $request->prixtotal - $request->avance;
        $vente->user_id = Auth()->user()->id;
        $vente->prixtotal = $request->prixtotal;
        $vente->client_id = $request->client;
        $vente->modepayement_id = $request->idmod;
        $vente->dateecheance = Carbon::now();
        $vente->lieustock_id = $request->idlieutoock;
        $vente->comment = $request->comment;
        $vente->transporteur = $request->transporteur;
//hwayj moochtaraka
//fiin hwayj mochtaraka
        if ($request->bonstatut == 2) {
            switch ($request->idmod) {
                case 1://espece
                    $caisse=caisse::where('typecasse_id', 1)
                    ->where('entrer_id', $vente->id)
                    ->first();
                    $caisse->delete();
                    //supprim cheque
                    $cheque =   cheque::where('vente_id', $vente->id)->first();
                    if ($cheque) {
                        $cheque->delete();
                    }
                    //regle client  espece vercement
                    $client1 = client::where('id', $request->client)->first();
                    $client1->monton -= $vente->rest;
                    $client1->save();

                    $caisse = new caisse();
                    $caisse->typecasse_id=1;
                    $caisse->client_id = $request->client;
                    $caisse->montant = $request->prixtotal;
                    $caisse->entrer_id = $vente->id;
                    $caisse->save();
                    $vente->rest = 0; //hada dima ltht
                    $vente->avance = 0;
                    $vente->encour_id = 1; //payer
                    break;
                case 2://credit
                    $caisse=caisse::where('typecasse_id', 1)
                    ->where('entrer_id', $vente->id)
                    ->first();
                    $caisse->delete();
                    if($vente->modepayement_id==2){
                              //regle client  espece vercement
                           $client1 = client::where('id', $request->client)->first();
                           $client1->monton -= $vente->rest;
                           $client1->save(); 
                    }
                    
                    //supprim cheque
                    $cheque =   cheque::where('vente_id', $vente->id)->first();
                    if ($cheque) {
                        $cheque->delete();
                    }
                    $vente->rest = $request->prixtotal - $request->avance;
                    $vente->avance = $request->avance;
                    //regle client
                    $client = client::where('id', $request->client)->first();
                    $client->monton += $esto;
                    $client->save();
                    $caisse = new caisse();
                    $caisse->typecasse_id=1;
                    $caisse->client_id = $request->client;
                    $caisse->montant = $request->avance;
                    $caisse->entrer_id = $vente->id;
                    $caisse->save();
                    $vente->encour_id = 2; //credit
                    break;
                case 3://cheque
                    //supprme caisse      
                    $caisse=caisse::where('typecasse_id', 1)
                    ->where('entrer_id', $vente->id)
                    ->first();
                    $caisse->delete();
                    //regle client  espece vercement  
                    $client1 = client::where('id', $request->client)->first();
                    $client1->monton -= $vente->rest;
                    $client1->save();
                    $vente->rest = 0; //hada dima ltht
                    $vente->avance = 0;
                    $cheque =   cheque::where('vente_id', $vente->id)->first();
                    if ($cheque) {
                        $cheque->client_id = $request->client;
                        $cheque->vente_id = $vente->id;
                        $cheque->numero = $request->numero;
                        $cheque->boonque = $request->boonque;
                        $cheque->montant = $request->prixtotal;
                        $cheque->date = $request->date;
                        $cheque->save();
                    } else {
                        $cheque1 = new cheque();
                        $cheque1->client_id = $request->client;
                        $cheque1->vente_id = $vente->id;
                        $cheque1->numero = $request->numero;
                        $cheque1->boonque = $request->boonque;
                        $cheque1->montant = $request->prixtotal;
                        $cheque1->date = $request->date;
                        $cheque1->save();
                    }
          
                    break;
                case 4://versement
                    //supprme caisse
                    $caisse=caisse::where('typecasse_id', 1)
                    ->where('entrer_id', $vente->id)
                    ->first();
                    $caisse->delete();
                    $cheque =   cheque::where('vente_id', $vente->id)->first();
                    if ($cheque) {
                        $cheque->delete();
                    }

                    //regle client  espece vercement
                    $client1 = client::where('id', $request->client)->first();
                    $client1->monton -= $vente->rest;
                    $client1->save();
                    $vente->rest = 0; //hada dima ltht
                    $vente->avance = 0;
                    $caisse = new caisse();
                    $caisse->typecasse_id=1;
                    $caisse->client_id = $request->client;
                    $caisse->montant = $request->prixtotal;
                    $caisse->entrer_id = $vente->id; //payer
                    $caisse->save(); //payer
                    break;
                case 5:
                    dd('5');
                    break;
            }
            $vente->save();
            //modfier cart
            if ($vente->save()) {


                foreach ($request->cart as $cart) {
                    $productIsExist = $vente->detaille_vente()->where('produit_id',$cart['id'])->first();
                    logger($productIsExist);
                    if($productIsExist){
                        $det = $productIsExist;
                        $hangeproduit = -$det->quantite + $cart['quantite'];
                        $qtyold = $det->quantite;
                        $det->vente_id = $vente->id;
                        $det->produit_id = $cart['id'];
                        $det->quantite = $cart['quantite'];
                        $det->x = $cart['x']; //twli prix vente
                        $det->comme = 'rr';
                        $det->nom = $cart['nom'];
                        $det->prixvents = $cart['prixvents'];
                        $det->prixun = 22;
                        $det->save();
                        $produit=produit::where('id',$det->produit_id)->first();
                        $produit->stock-= $hangeproduit;
                        $produit->save(); 
                            //stock
                            $stock= new stock();
                            $stock->user_id=Auth()->user()->id;
                            $stock->produit_id= $produit->id;
                            $stock->mouvement_id=2;//
                            $stock->qty = $cart['quantite'];
                            $stock->save();
                            $stock2= new stock();
                            $stock2->user_id=Auth()->user()->id;
                            $stock2->produit_id= $produit->id;
                            $stock2->mouvement_id=1;//
                            $stock2->qty = $qtyold;
                            $stock2->save();
                        
                          
                        
                                $hystoriqprix= new hystoriqprix();
                                
                                $hystoriqprix->produit_id= $produit->id;
                                $hystoriqprix->client_id=$request->client;
                                $hystoriqprix->prixvente=$cart['prixvents'];
                                $hystoriqprix->save();
                    }else{
                        $vente->detaille_vente()->create([
                            'produit_id' => $cart['id'],
                            'quantite' => $cart['quantite'],
                            'x' => $cart['x'],
                            'comme' => 'ddd',
                            'nom' => $cart['nom'],
                            'prixvents' => $cart['prixvents'],
                            'prixun' => 22,
                        ]);
                        $produit = produit::where('id', $cart['id'])->first();
                        $produit->stock -= $cart['quantite'];
    
                        $produit->save();
    
                        $stock = new stock();
                        $stock->user_id = Auth()->user()->id;
                        $stock->produit_id = $produit->id;
                        $stock->mouvement_id = 2; //
                        $stock->qty = $cart['quantite'];
                        $stock->save();     
                        $hystoriqprix = new hystoriqprix();

                        $hystoriqprix->produit_id = $produit->id;
                        $hystoriqprix->client_id = $request->client;
                        $hystoriqprix->prixvente = $cart['prixvents'];
                        $hystoriqprix->save();
                    }      
                }                
            }

            //fin modifiier cart











            //fin hna dir back();
        } elseif ($request->bonstatut == 1) {
            $this->destroy($id);
            $enattend = new enattend();
            $enattend->user_id = Auth()->user()->id;
            $enattend->prixtotal = $request->prixtotal;
            $enattend->client_id = $request->client;
            $enattend->modepayement_id = $request->idmod;
            $enattend->dateecheance = Carbon::now();
            $enattend->lieustock_id = $request->idlieutoock;
            $enattend->comment = $request->comment;
            $enattend->transporteur = $request->transporteur;
            $enattend->encour_id = 2; //credit
            $enattend->avance = $request->avance;
            $enattend->rest = $request->prixtotal - $request->avance;




            $enattend->bonenattentsituation_id = $request->bonstatut;
            $enattend->crediiturgent_id = $request->crediturgent;

            $enattend->activebutton_id = 1; //achnou hadi?
            $enattend->remise = $request->remise;
            $enattend->save();



            foreach ($request->cart as $req => $key) {

                $detaille_enattend = new detaille_enattend();
                $detaille_enattend->enattend_id = $enattend->id;
                $detaille_enattend->produit_id = $request->cart[$req]['id'];
                $detaille_enattend->qty = $request->cart[$req]['quantite'];
                $detaille_enattend->total = $request->cart[$req]['x']; //twli prix vente
                $detaille_enattend->comment = $request->cart[$req]['comme'];
                $detaille_enattend->prixvente = $request->cart[$req]['prixvents'];
                $detaille_enattend->save();
            }
            return response()->json(['enattend' => $enattend]);
           
        }




        return back();
    }












    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\vente  $vente
     * @return \Illuminate\Http\Response
     */

    function date_vente(Request $request)
    {
        // dd($request->all());
        $enattend = enattend::whereBetween('created_at', [$request->debut, $request->fin])
            ->get();
        $encour = encour::all();
        $clients = client::all();
        $villes = ville::all();
        $statuts = statut::all();
        $catclientfrns = catclientfrn::all();
        $ventes = vente::whereBetween('created_at', [$request->debut, $request->fin])
            ->get();
        $ventes_encour = vente::where('encour_id', 2)->whereBetween('created_at', [$request->debut, $request->fin])
            ->get();
        $ventes_payer = vente::where('encour_id', 1)->whereBetween('created_at', [$request->debut, $request->fin])
            ->get();
        $ventes_enatted = vente::where('bonenattentsituation_id', 1)->whereBetween('created_at', [$request->debut, $request->fin])
            ->get();
        $ventes_urgent = vente::where('crediiturgent_id', 2)->whereBetween('created_at', [$request->debut, $request->fin])
            ->get();
        return view('admin.all_ventes', [

            'clients' => $clients,
            'villes' => $villes,
            'statcatclientfrnsuts' => $catclientfrns,
            'statuts' => $statuts,
            'ventes' => $ventes,
            'encour' => $encour,

            'enattend' => $enattend,
            'ventes_encour' => $ventes_encour,
            'ventes_payer' => $ventes_payer,
            'ventes_enatted' => $ventes_enatted,
            'ventes_urgent' => $ventes_urgent,




        ]);
    }
    public function edit(vente $vente)
    {
        //
    }
    public function lastid()
    {
        $lasid = vente::latest('id')->first();
        return response()->json(['lasid' => $lasid]);
    }
    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\vente  $vente
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, vente $vente)
    {
        //
    }
    public function modifevente(Request $request, $id)
    {
        $ventes = vente::where('id', $id)->first();
        $detaille_vente = detaille_vente::where('vente_id', $id)->get();

        return view('admin.modifevente', ['ventes' => $ventes, 'detaille_vente' => $detaille_vente]);
    }
    public function modifevente2(Request $request)
    {

        $id = $request->idvente;
        $ventes = vente::where('id', $id)->first();
        $detaille_vente = detaille_vente::where('vente_id', $id)->get();
        return view('admin.modifevente', ['ventes' => $ventes, 'detaille_vente' => $detaille_vente]);
    }

    public function modifeventejson($id)
    {
        $ventes = vente::where('id', $id)->first();
        $detaille_vente = detaille_vente::where('vente_id', $id)->with('produit')->get();


        return response()->json(['ventes' => $ventes, 'detaille_vente' => $detaille_vente]);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\vente  $vente
     * @return \Illuminate\Http\Response
     */

    public function reglevente(Request $request)
    {
        $data = $request->ids;

        foreach ($data  as $req => $key) {

            $vente = vente::where('id', $data[$req])->first();
            //caisse
            $caisse = new caisse();
            $caisse->entrer = $vente->rest;
            $caisse->srtie = 0;
            $caisse->justif = "reglement client n:" . $vente->id;
            $caisse->save();

            //caisse
            $client = client::where('id', $vente->client_id)->first();

            $client->monton -= $vente->rest;

            $client->save();




            $vente->rest;
            $vente->rest = 0;
            $vente->avance = $vente->prixtotal;
            $vente->encour_id = 1;
            $vente->save();




            //client
        }



        return back();
    }

    public function destroy($id)
    {

        $vente = vente::where('id', $id)->first();


        //regle caisse
        if ($vente->modepayement_id == 2) { //2credit
            $client = client::where('id', $vente->client_id)->first();
            $client->monton -= $vente->rest;
            $client->save();

            $caisse = new caisse();
            $caisse->entrer = 0;
            $caisse->srtie = $vente->avance;

            $caisse->justif = "supriimer facture n:" . $vente->id;
            $caisse->save();
        }
        if ($vente->modepayement_id == 1 or $vente->modepayement_id == 4) { //1 espece

            $caisse = new caisse();
            $caisse->entrer = 0;
            $caisse->srtie = $vente->prixtotal;

            $caisse->justif = "supriimer facture n:" . $vente->id;
            $caisse->save();
        }

        if ($vente->modepayement_id == 3) { //1 espece
            $cheque = cheque::where('vente_id', $vente->id)->first();
            $cheque->delete();
            $caisse = new caisse();
            $caisse->entrer = 0;
            $caisse->srtie = $vente->prixtotal;

            $caisse->justif = "supriimer facture n:" . $vente->id;
            $caisse->save();
        }

        if ($vente->modepayement_id == 5) { //1 espece
            $cheque = cheque::where('vente_id', $vente->id)->first();
            $cheque->delete();
            $caisse = new caisse();
            $caisse->entrer = 0;
            $caisse->srtie = $vente->prixtotal;

            $caisse->justif = "supriimer facture n:" . $vente->id;
            $caisse->save();
        }
        $detaille_vente = detaille_vente::where('vente_id', $vente->id)->get();
        foreach ($detaille_vente as $det) {

            $produit = produit::where('id', $det->produit_id)->first();
            $produit->stock += $det->quantite;
            $produit->save();
            $stock2 = new stock();
            $stock2->user_id = Auth()->user()->id;
            $stock2->produit_id = $produit->id;
            $stock2->mouvement_id = 1; //
            $stock2->qty = $det->quantite;
            $stock2->save();
        }
        foreach ($detaille_vente as $det) {
            $det->delete();
        }
        $vente->delete();

        return redirect()->back()->with('success', ' bien supprimer');
    }


    public function destcaisse($id)
    {
        $caisse=caisse::where('id', $id)->first();
        $caisse->delete();
    }
}


