<?php

namespace App\Http\Controllers;
use App\Models\depense;
use App\Models\produit;
use App\Models\reglement_cl;
use App\Models\stock;
use App\Models\info;
use App\Models\ville;
use App\Models\statut;
use App\Models\encour;
use App\Models\vente;
use App\Models\client;
use App\Models\catclientfrn;
use App\Models\enattend;
use App\Models\caisse;
use App\Models\detaille_bonlivraison;
use App\Models\hystorique_factur;
use App\Models\bonlivraison;
use App\Models\detaille_vente;
use App\Models\hystoriqprix;
use App\Models\cheque;

use App\Models\depensevente;

use App\Models\detaille_enattend;
use Barryvdh\DomPDF\Facade\Pdf;
use Illuminate\Http\Request;
use \Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;

class VenteController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function adminpdf()
    {





        $pdf = PDF::loadView('admin.chart')->setOptions(['defaultFont' => 'sans-serif']);
        // $pdf = PDF::loadView('chart',['facture'=>$facture,'infoadmin'=>$infoadmin])->setOptions(['defaultFont' => 'sans-serif']);

        return $pdf->download('facturepdf.pdf');
    }
    public function index()
    {

        $clients = client::all();
        $villes = ville::all();
        $statuts = statut::all();
 
        return view('admin.vente', [

            'clients' => $clients,
            'villes' => $villes,
        
            'statuts' => $statuts,
        ]);
    }

    public function caissebl()
    {
        $caisse=caisse::orderBy('created_at','desc')->get();

       /// $ventes = vente::where('modepayement_id',1)->get();
      
        $cheques = cheque::all();
        $depenses= depense::all();
        $sumcaisse = caisse::sum('montant');
        $sumcheque = cheque::sum('montant');
        $sumdepense = depense::sum('depense');
        return view('admin.caissebl', [
            'depenses' => $depenses,
            'sumcaisse' => $sumcaisse,
            'cheques' => $cheques,
            
            'sumcheque' => $sumcheque,
            'sumdepense' => $sumdepense,
            'caisse' => $caisse,
       
        ]);
    }
    public function all_ventes()
    {

        $clients = client::all();
        $villes = ville::all();
        $statuts = statut::all();
   
        $ventes = vente::orderBy('created_at', 'desc')->paginate(10); 
        
   
        return view('admin.all_ventes', [

            'clients' => $clients,
            'villes' => $villes,
       
            'statuts' => $statuts,
            'ventes' => $ventes,
          

        
       




        ]);
    }
    public function facturvente()
    {
        $encour = encour::all();
        $ventes = vente::all();
        return view('admin.facturvente', ['ventes' => $ventes, 'encour' => $encour]);
    }
    public function detaillefacturvente($id)
    {
        $info = info::all();
        $encour = encour::all();
        $ventes = vente::where('id', $id)->first();
        return view('admin.facturedetaille', ['ventes' => $ventes, 'encour' => $encour, 'info' => $info]);
    }
    public function bonlivraison()
    {
        $encour = encour::all();
        $bonlivraisons = bonlivraison::all();
        return view('admin.bonlivraison', ['bonlivraisons' => $bonlivraisons, 'encour' => $encour]);
    }
    public function reglementclient()
    {
        $clients = client::all();
        $reglement = reglement_cl::orderBy('created_at','desc')->paginate(10);
      
        return view('admin.reglclient', [ 'reglement' => $reglement, 'clients' => $clients]);
    }

    public function reglementclient_all()
    {

        $encour = encour::all();
        $ventes = vente::where('encour_id', 2)->get();
        return view('admin.reglementclient_all', ['ventes' => $ventes, 'encour' => $encour]);
    }
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function blenatted()
    {

        $ventes = vente::where('bonenattentsituation_id', 1)->get();
        return view('admin.blenatted', ['ventes' => $ventes]);
    }
    public function blconfirme()
    {
        $ventes = vente::where('bonenattentsituation_id', 2)->get();
        return view('admin.blconfirme', ['ventes' => $ventes]);
    }

    public function blurgent()
    {

        $ventes = vente::where('crediiturgent_id', 2)->get();
        return view('admin.blurgent', ['ventes' => $ventes]);
    }
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        // Créer une nouvelle vente
        $vente = new Vente();
        $vente->user_id = Auth::id();  // ID de l'utilisateur connecté
        $vente->ref = $request->ref;  
        $vente->client_id = $request->idclient;  
        $vente->modepayement_id = $request->modepayement_id;  
        $vente->prixtotal = $request->prixtotal;  
        $vente->totalTVA = $request->totaltva;
        $vente->totalavecTVA = $request->totalavecTVA;
        $vente->totalremise = $request->totalremise;
        $vente->encour_id = 1;  // Statut par défaut
     
        
        // Gestion du paiement
        if ($request->modepayement_id == 1) { // Espèce
            $vente->avance = $request->prixtotal;
            $vente->rest = 0;
        } elseif ($request->modepayement_id == 2) { // Crédit
            $vente->avance = $request->avance;
            $vente->rest = $request->prixtotal - $request->avance;
        } elseif ($request->modepayement_id == 3) { // Chèque
            $vente->avance = $request->avance;
            $vente->rest = $request->prixtotal - $request->avance;
        }
    
        // Sauvegarde de la vente
        $vente->save();
    
        // Enregistrement des articles du panier
        foreach ($request->cart as $item) {
            $itemVente = new detaille_vente();
            $itemVente->vente_id = $vente->id;
            $itemVente->desc = $item['desc'];
            $itemVente->quantite = $item['quantite'];
            $itemVente->prix_vente = $item['prixvente'];
            $itemVente->tva = $item['tva'];
            $itemVente->remise = $item['remise'];
            $itemVente->total = $item['total'];
            $itemVente->save();
        }
    
        // Enregistrement dans la caisse si paiement en espèce ou chèque
        if ($request->modepayement_id == 1 || $request->modepayement_id == 3) {
            $caisse = new caisse();
            $caisse->montant = $vente->avance;
            $caisse->client_id = $request->idclient;
            $caisse->typecasse_id = 1;
            $caisse->entrer_id = $vente->id;
            $caisse->save();
        }
    
        return response()->json(['message' => 'Vente ajoutée avec succès'], 200);
    }
    
    
    public function storebonmivraison(Request $request)
    {


    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\vente  $vente
     * @return \Illuminate\Http\Response
     */
    public function moodifvente(Request $request, $id)
    {

        $vente = vente::where('id', $id)->first();
        $vente->bonenattentsituation_id = 2;
        $vente->save();
        $detaille_vente = detaille_vente::where('vente_id', $request->id)->get();
        $products_ids = $detaille_vente->pluck('produit_id')->toArray();

        $products = produit::whereIn('id', $products_ids)->get();

        foreach ($detaille_vente as $item) {
            $product = $products->where('id', $item->produit_id)->first();
            $new_stock = $product->stock - $item->qty;
            produit::where('id', $item->produit_id)->update(['stock' => $new_stock]);
        }



        /*
    $stock= new stock();
    $stock->user_id=Auth()->user()->id;
    $stock->produit_id=  $item->produit_id;
    $stock->mouvement_id=2;
    $stock->qty =$item->qty ;
    $stock->save();




  



    $caisse= new caisse();
$caisse->entrer=$request->prixtotal;
$caisse->srtie=0;
$caisse->justif="vente facture n 20";
$caisse->save();

*/




        return redirect()->back()->with('success', ' bien enregistrer');
    }

    public function modifier_vente(Request $request, $id)
    {
     
        $vente = vente::where('id', $id)->first();
        $olderest = $vente->rest;
        $esto = $request->prixtotal - $request->avance;
        $vente->user_id = Auth()->user()->id;
        $vente->prixtotal = $request->prixtotal;
        $vente->client_id = $request->client;
        $vente->modepayement_id = $request->idmod;
        $vente->dateecheance = Carbon::now();
        $vente->lieustock_id = $request->idlieutoock;
        $vente->comment = $request->comment;
        $vente->transporteur = $request->transporteur;

            //trasabilite
    $hystorique_factur= new hystorique_factur();
    $hystorique_factur->facture_id = $vente->id;
    $hystorique_factur->user_id=Auth()->user()->id;
    $hystorique_factur->catfacture_id=2; // 1 cree 2 modifier 3supprimer;
    $hystorique_factur->typecasse_id=1;// 1 vente 2 avoir 3reglement 4 achat 5 commande 6 devis;
    $hystorique_factur->save();

//hwayj moochtaraka
$caisse=caisse::where('typecasse_id', 1)
->where('entrer_id', $vente->id)
->first();
if($caisse){
$caisse->delete();}
//supprim cheque
$cheque =   cheque::where('vente_id', $vente->id)->first();
if ($cheque) {
  
    $cheque->delete();
}
$reglement = reglement_cl::where('vente_id',  $vente->id)
->get();
if($reglement){
    foreach($reglement as $reg){
      $reg->delete();  
    }
}
//fiin hwayj mochtaraka
        if ($request->bonstatut == 2) {
            switch ($request->idmod) {
                case 1://espece
           
                    //regle client  espece vercement
                    $client1 = client::where('id', $request->client)->first();
                    $client1->monton -= $vente->rest;
                    $client1->save();

                    $caisse = new caisse();
                    $caisse->typecasse_id=1;
                    $caisse->client_id = $request->client;
                    $caisse->montant = $request->prixtotal;
                    $caisse->entrer_id = $vente->id;
                    $caisse->save();
                    $vente->rest = 0; //hada dima ltht
                    $vente->avance = 0;
                    $vente->encour_id = 1; //payer
                    break;
                case 2://credit
            
                    if($vente->modepayement_id==2){
                              //regle client  espece vercement
                           $client1 = client::where('id', $request->client)->first();
                           $client1->monton -= $vente->rest;
                           $client1->save(); 
                    }
                    
        
                    $vente->rest = $request->prixtotal - $request->avance;
                    $vente->avance = $request->avance;
                    //regle client
                    $client = client::where('id', $request->client)->first();
                    $client->monton += $esto;
                    $client->save();
                    $caisse = new caisse();
                    $caisse->typecasse_id=1;
                    $caisse->client_id = $request->client;
                    $caisse->montant = $request->avance;
                    $caisse->entrer_id = $vente->id;
                    $caisse->save();
                    $vente->encour_id = 2; //credit
                    break;
                case 3://cheque
                    //supprme caisse      
     
                    //regle client  espece vercement  
                    $client1 = client::where('id', $request->client)->first();
                    $client1->monton -= $vente->rest;
                    $client1->save();
                    $vente->rest = 0; //hada dima ltht
                    $vente->avance = 0;
                    $cheque =   cheque::where('vente_id', $vente->id)->first();
                    if ($cheque) {
                        $cheque->client_id = $request->client;
                        $cheque->vente_id = $vente->id;
                        $cheque->numero = $request->numero;
                        $cheque->boonque = $request->boonque;
                        $cheque->montant = $request->prixtotal;
                        $cheque->date = $request->date;
                        $cheque->save();
                    } else {
                        $cheque1 = new cheque();
                        $cheque1->client_id = $request->client;
                        $cheque1->vente_id = $vente->id;
                        $cheque1->numero = $request->numero;
                        $cheque1->boonque = $request->boonque;
                        $cheque1->montant = $request->prixtotal;
                        $cheque1->date = $request->date;
                        $cheque1->save();
                    }
          
                    break;
                case 4://versement
                    //supprme caisse
          
                    //regle client  espece vercement
                    $client1 = client::where('id', $request->client)->first();
                    $client1->monton -= $vente->rest;
                    $client1->save();
                    $vente->rest = 0; //hada dima ltht
                    $vente->avance = 0;
                    $caisse = new caisse();
                    $caisse->typecasse_id=1;
                    $caisse->client_id = $request->client;
                    $caisse->montant = $request->prixtotal;
                    $caisse->entrer_id = $vente->id; //payer
                    $caisse->save(); //payer
                    break;
                case 5:
                    dd('5');
                    break;
            }
            $vente->save();
            //modfier cart
            if ($vente->save()) {


                foreach ($request->cart as $cart) {
                    $productIsExist = $vente->detaille_vente()->where('produit_id',$cart['id'])->first();
                    logger($productIsExist);
                    if($productIsExist){
                        $det = $productIsExist;
                        $hangeproduit = -$det->quantite + $cart['quantite'];
                        $qtyold = $det->quantite;
                        $det->vente_id = $vente->id;
                        $det->produit_id = $cart['id'];
                        $det->quantite = $cart['quantite'];
                        $det->x = $cart['x']; //twli prix vente
                        $det->comme = 'rr';
                        $det->nom = $cart['nom'];
                        $det->prixvents = $cart['prixvents'];
                        $det->prixun = 22;
                        $det->save();
                        $produit=produit::where('id',$det->produit_id)->first();
                        $produit->stock-= $hangeproduit;
                        $produit->save(); 
                            //stock
                            $stock= new stock();
                            $stock->user_id=Auth()->user()->id;
                            $stock->produit_id= $produit->id;
                            $stock->mouvement_id=2;//
                            $stock->qty = $cart['quantite'];
                            $stock->save();
                            $stock2= new stock();
                            $stock2->user_id=Auth()->user()->id;
                            $stock2->produit_id= $produit->id;
                            $stock2->mouvement_id=1;//
                            $stock2->qty = $qtyold;
                            $stock2->save();
                        
                          
                    
                    }else{
                        $vente->detaille_vente()->create([
                            'produit_id' => $cart['id'],
                            'quantite' => $cart['quantite'],
                            'x' => $cart['x'],
                            'comme' => 'ddd',
                            'nom' => $cart['nom'],
                            'prixvents' => $cart['prixvents'],
                            'prixun' => 22,
                        ]);
                        $produit = produit::where('id', $cart['id'])->first();
                        $produit->stock -= $cart['quantite'];
    
                        $produit->save();
    
                        $stock = new stock();
                        $stock->user_id = Auth()->user()->id;
                        $stock->produit_id = $produit->id;
                        $stock->mouvement_id = 2; //
                        $stock->qty = $cart['quantite'];
                        $stock->save();     
                     
                    }      
                }                
            }

            //fin modifiier cart











            //fin hna dir back();
        }




        return redirect()->back()->with('success', ' bien enregistrer');
    }












    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\vente  $vente
     * @return \Illuminate\Http\Response
     */



    function date_vente(Request $request)
    {
     
        $encour = encour::all();
        $clients = client::all();
        $villes = ville::all();
        $statuts = statut::all();
       
        $ventes = vente::whereBetween('created_at', [
            Carbon::parse($request->debut)->startOfDay(),
            Carbon::parse($request->fin)->endOfDay(),
        ])
        ->paginate(10); 
        return view('admin.all_ventes', [

            'clients' => $clients,
            'villes' => $villes,
         
            'statuts' => $statuts,
            'ventes' => $ventes,
        




        ]);
    }
    public function edit(vente $vente)
    {
        //
    }
    public function lastid()
    {
        $lasid = vente::latest('id')->first();
        return response()->json(['lasid' => $lasid]);
    }
    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\vente  $vente
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, vente $vente)
    {
        //
    }
    public function modifevente(Request $request, $id)
    {
        $ventes = vente::where('id', $id)->first();
        $detaille_vente = detaille_vente::where('vente_id', $id)->get();

        return view('admin.modifevente', ['ventes' => $ventes, 'detaille_vente' => $detaille_vente]);
    }
    public function modifevente2(Request $request)
    {

        $id = $request->idvente;
        $ventes = vente::where('id', $id)->first();
        $detaille_vente = detaille_vente::where('vente_id', $id)->get();
        return view('admin.modifevente', ['ventes' => $ventes, 'detaille_vente' => $detaille_vente]);
    }

    public function modifeventejson($id)
    {
        $ventes = vente::where('id', $id)->first();
        $detaille_vente = detaille_vente::where('vente_id', $id)->with('produit')->get();


        return response()->json(['ventes' => $ventes, 'detaille_vente' => $detaille_vente]);
    }
    public function mdifdate(Request $request,$id)
    {
      
        $vente = vente::where('id', $id)->first();
        $vente->created_at = $request->date;
       $vente->save();


        return back();
    }
    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\vente  $vente
     * @return \Illuminate\Http\Response
     */

    public function reglevente(Request $request)
    {
        $data = $request->ids;

        foreach ($data  as $req => $key) {

            $vente = vente::where('id', $data[$req])->first();
            //caisse

            $caisse = new caisse();
            $caisse->typecasse_id=1;
            $caisse->client_id = $vente->client_id;
            $caisse->montant = $vente->rest;
            $caisse->entrer_id = $vente->id;
            $caisse->save();

            //caisse
            $client = client::where('id', $vente->client_id)->first();

            $client->monton -= $vente->rest;

            $client->save();




            $vente->rest;
            $vente->rest = 0;
            $vente->avance = $vente->prixtotal;
            $vente->crediiturgent_id=1;
            $vente->encour_id = 1;
            $vente->save();

            $reglement= new reglement_cl();
            $reglement->client_id=$vente->client_id;
            $reglement->vente_id=$vente->id;
            $reglement->montant=$vente->prixtotal;
            $reglement->rest=0;
            $reglement->observation="rien";
            
            $reglement->save();


            //client
        }



        return back();
    }



public function deletelignevente ($id){
   
    $detaille_vente = detaille_vente::where('id', $id)->first();
    $detaille_vente->delete();
    return response()->json(['detaille_vente' => $detaille_vente]);
}




    public function destroy($id)
    {

        $vente = vente::where('id', $id)->first();
        $caisse=caisse::where('typecasse_id', 1)
        ->where('entrer_id', $vente->id)
        ->first();
        if($caisse){
        $caisse->delete();}
     
 

  

        $detaille_vente = detaille_vente::where('vente_id', $vente->id)->get();
        foreach ($detaille_vente as $det) {

         /*   $produit = produit::where('id', $det->produit_id)->first();
            $produit->stock += $det->quantite;
            $produit->save();
     */
        }
     

       foreach ($detaille_vente as $det) {
            $det->delete();
        }
        $vente->delete();




        return redirect()->back()->with('success', ' bien supprimer');
    }


    public function destcaisse($id)
    {
        $caisse=caisse::where('id', $id)->first();
        $caisse->delete();
    }


    public function genererNumeroFacture()
    {
        // Récupérer le dernier ID dans la table 'vente'
        $dernierId = Vente::max('id');
    
        // Calculer le prochain ID
        $prochainId = $dernierId ? $dernierId + 1 : 1;
    
        // Générer le numéro de facture adapté
        $numeroFacture = $prochainId;
    
        // Retourner une réponse JSON
        return response()->json([
            'success' => true,
            'numero_facture' => $numeroFacture,
        ]);
    }
    

  }
