<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateFournisseursTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('fournisseurs', function (Blueprint $table) {
            $table->id();
            $table->string('nom');
            $table->string('tele')->nullable();
            $table->integer('monton')->nullable();
            $table->bigInteger('statut_id')->unsigned()->nullable();
            $table->foreign('statut_id')->references('id')->on('statuts');
       
            $table->bigInteger('ville_id')->unsigned()->nullable();
            $table->foreign('ville_id')->references('id')->on('villes');
            $table->string('email')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('fournisseurs');
    }
}
