<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateVentesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('ventes', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('user_id')->unsigned();
            $table->foreign('user_id')->references('id')->on('users');
            $table->string('ref'); // Numéro de facture
            $table->foreignId('modepayement_id')->nullable()->constrained('modepayements')->onDelete('set null');
            $table->foreignId('client_id')->constrained('clients')->onDelete('cascade');
            $table->decimal('prixtotal', 10, 2);
            $table->decimal('totalavecTVA', 10, 2);
            $table->decimal('totalremise', 10, 2);
            $table->decimal('totalTVA', 10, 2)->default(0);
            $table->bigInteger('encour_id')->unsigned();
            $table->foreign('encour_id')->references('id')->on('encours');
            $table->integer('avance')->default(0);
            $table->integer('rest')->default(0);
      
           
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('ventes');
    }
}
