<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateDevisTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('devis', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('user_id')->unsigned();
            $table->foreign('user_id')->references('id')->on('users');
            $table->string('ref'); // Numéro de facture
            $table->foreignId('client_id')->constrained('clients')->onDelete('cascade');
            $table->decimal('prixtotal', 10, 2);
            $table->decimal('pourcentageremise', 5, 2)->default(0);
            $table->decimal('pourcentagetva', 5, 2)->default(0);
            $table->decimal('totalavecTVA', 10, 2);
            $table->decimal('totalremise', 10, 2);
  
        
       

    
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('devis');
    }
}
