<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateDetailleDevisTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('detaille_devis', function (Blueprint $table) {
            $table->id();
          
            $table->foreignId('devis_id')->constrained('devis')->onDelete('cascade');
            $table->string('desc');
            $table->integer('quantite')->default(1);
            $table->decimal('prix_vente', 10, 2);
            $table->decimal('tva', 5, 2)->default(0);
            $table->decimal('remise', 5, 2)->default(0);
            $table->decimal('total', 10, 2);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('detaille_devis');
    }
}
