<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateBonlivraisonsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('bonlivraisons', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('user_id')->unsigned();
         
            $table->foreign('user_id')->references('id')->on('users');
               $table->integer('ref_vente');
            $table->integer('prixtotal');
            $table->date('dateecheance');
            $table->bigInteger('lieustock_id')->unsigned();
            $table->foreign('lieustock_id')->references('id')->on('lieustocks');
            $table->bigInteger('encour_id')->unsigned();
            $table->foreign('encour_id')->references('id')->on('encours');
    
            $table->bigInteger('modepayement_id')->unsigned();
            $table->foreign('modepayement_id')->references('id')->on('modepayements');
            $table->bigInteger('client_id')->unsigned();
            $table->foreign('client_id')->references('id')->on('clients');
            $table->integer('avance');
            $table->integer('rest');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('bonlivraisons');
    }
}
