@extends('layouts.appadmin')

@section('content')
<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-12">
                    <h1 class="font-weight-bold">Caisse </h1>
                    <span class="badge badge-pill badge-success" style="font-size:20px;">
                        montant espèces : {{$sumcaisse}} DH
                    </span>
                    <span class="badge badge-pill badge-danger" style="font-size:20px;">
                        dépenses : {{$sumdepense}} DH
                    </span>
                    <span class="badge badge-pill badge-danger" style="font-size:20px;">
                        caisse : {{$sumcaisse - $sumdepense}} DH
                    </span>
                </div>
            </div>
        </div>
    </div>

    <!-- Formulaire de Recherche -->
    <div class="card">
        <div class="card-body">
          <form method="GET" action="{{ route('caisse.chercherParDate') }}" class="mb-4">
            <div class="row">
                <div class="col-md-4">
                    <label for="start_date">Date de début :</label>
                    <input type="date" name="start_date" id="start_date" class="form-control" value="{{ old('start_date', $startDate ?? '') }}">
                </div>
                <div class="col-md-4">
                    <label for="end_date">Date de fin :</label>
                    <input type="date" name="end_date" id="end_date" class="form-control" value="{{ old('end_date', $endDate ?? '') }}">
                </div>
                <div class="col-md-4 d-flex align-items-end">
                    <button type="submit" class="btn btn-primary">Rechercher</button>
                </div>
            </div>
        </form>
        </div>
    </div>

    <!-- Section Caisse -->
    <section class="content">
        <div class="card">
            <div class="card-header bg-info">
                <h3 class="card-title">Entrées</h3>
            </div>
            <div class="card-body">
                <table class="table table-bordered table-striped">
                    <thead>
                        <tr>
                            <th>Type</th>
                           
                            <th>Montant</th>
                            <th>Date</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($caisse as $cais)
                        <tr>
                            <td class="{{ $cais->typecasse_id == 2 ? ' font-weight-bold' : '' }}">
                                {{$cais->typecasse->type}}
                            </td>
                           
                            <td class="text-success font-weight-bold">{{$cais->montant}} DH</td>
                            <td>{{$cais->created_at->format('d M Y, G:i')}}</td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
                <div id="paginationLinks" class="d-flex justify-content-center mt-4">
                  
                </div>
            </div>
        </div>
    </section>

    <!-- Section Dépenses -->
    <section class="content">
        <div class="card">
            <div class="card-header bg-info">
                <h3 class="card-title">Dépenses</h3>
            </div>
            <div class="card-body">
                <table class="table table-bordered table-striped">
                    <thead>
                        <tr>
                            <th>Type</th>
                            <th>Nb</th>
                            <th>Montant</th>
                            <th>Date</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($depenses as $depense)
                        <tr>
                            <td style="font-weight:bold">{{$depense->depense }}</td>
                            <td style="font-weight:bold">{{$depense->nb }}</td>
                            <td class="text-danger font-weight-bold">{{$depense->prix}} DH</td>
                            <td>{{$depense->created_at->format('d M Y, G:i')}}</td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
              
            </div>
        </div>
    </section>
</div>
@endsection
