<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>Facture</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0; padding: 0;
            background-color: #fff;
            color: #333;
        }
        .invoice-box {
            max-width: 800px;
            margin: 30px auto;
            padding: 30px;
            background-color: #fff;
            box-shadow: 0 0 10px rgba(0,0,0,0.1);
            page-break-inside: avoid;
        }

        /* Header 50/50 */
.header {
  display: flex;
  align-items: center;  /* centre verticalement */
  justify-content: center; /* centre horizontalement tout le groupe */
  gap: 10px; /* espace entre logo et texte */
  margin-bottom: 40px;
}

.logo {
  width: 30px;
  height: 30px;
  flex-shrink: 0;
}

.logo img {
  width: 40px;
  height: 40px;
  object-fit: contain;
}

.company-name {
  font-size: 1.8rem;
  font-weight: bold;
  color: #222;
  line-height: 40px; /* même hauteur que l’image */
}


        .info-container {
            display: table;
            width: 100%;
            margin-bottom: 25px;
        }

        .company-info,
        .client-info {
            display: table-cell;
            width: 50%;
            vertical-align: top;
        }

        .client-info {
            padding: 10px;
            border: 1px solid #ddd;
            border-radius: 5px;
            background-color: #f9f9f9;
        }

        .invoice-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
            page-break-inside: avoid;
        }

        .invoice-table th, 
        .invoice-table td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }

        .invoice-table th {
            background-color: #f2f2f2;
        }

        .totals-container {
            text-align: right;
            margin-top: 20px;
        }

        .totals-container p {
            margin: 5px 0;
        }

        .total-amount {
            font-size: 1.5em;
            color: #333;
        }

        .payment-method {
            text-align: right;
            margin-top: 10px;
        }

        .payment-method p {
            margin: 5px 0;
        }

     .footer {
    width: 100%;
    position: fixed;
    bottom: 0;
    left: 0;
    right: 0;
    background-color: #fff;
    text-align: center;
    font-size: 0.7rem;      /* texte plus petit */
    padding: 4px 0;         /* padding vertical réduit */
    border-top: 1px solid #ddd;
    line-height: 1.1;       /* hauteur de ligne serrée */
}

.footer p {
    margin: 2px 0;          /* marges top/bottom très petites */
    font-weight: normal;
}

        /* Pour gérer les descriptions longues */
        .description-cell {
            word-wrap: break-word;
            white-space: normal;
            max-width: 200px;
            text-align: justify;
            vertical-align: top;
        }
    </style>
</head>
<body>

    <div class="invoice-box">
        <!-- En-tête -->

<div class="header">
   <div class="logo">
    @if(!empty($info->logo) && file_exists(public_path('img/' . $info->logo)))
      <img src="data:image/png;base64,{{ base64_encode(file_get_contents(public_path('img/' . $info->logo))) }}" alt="Logo" />
    @else
      <img src="data:image/png;base64,{{ base64_encode(file_get_contents(public_path('img/777.jpg'))) }}" alt="Logo par défaut" />
    @endif
  </div>
  <div class="company-name">
    {{ $info->nom ?? 'Nom de la Société' }}
  </div>
</div>

                <div class="info-container">
                    <div class="company-info">
                        <p style="font-weight: bold">Bon Commande N :{{$boncommandes->id}} </p>
                        <p >Date : {{$boncommandes->created_at}}</p>
                    </div>
			
            <div class="client-info">
                <p><strong>Fournisseur : {{$boncommandes->fournisseur->nom}}</strong></p>
                <p>k</p>
             
            </div>
        </div>
    

        <table class="invoice-table"  style="margin-top: 100px;" >
            <thead>
                <tr style="text-align: center">
                    <th>Designation</th>
					<th>Qty</th>
                    <th>PU</th>
                    <th>TOTAL</th>
                </tr>
            </thead>
            <tbody>
				@foreach($boncommandes->detaille_boncommande as $det)
				<tr style="outline: thin solid">
		
				<td>{{$det->desc}}</td>
				<td style="text-align: center;">{{$det->quantite}}</td>
				<td style="text-align: center;"> {{$det->prix_vente}} </td>
				<td style="text-align: center;">{{$det->total}} </td>
			
			</tr>
			@endforeach
            </tbody>
        </table>

        <div class="totals-container">
           
            <p><strong>Total : <span class="total-amount">{{$boncommandes->prixtotal}} DH</span></strong></p>
          
        </div>

      
    </div>

      <!-- Footer -->
    <div class="footer">
        <p>{{ $info->line1 ?? '' }}</p>
        <p>{{ $info->line2 ?? '' }}</p>
        <p>{{ $info->line3 ?? '' }}</p>
    </div>
</body>
</html>


