<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});
Route::get('/test', [App\Http\Controllers\Controller::class, 'test']);
Auth::routes();


Route::get('/gethystorique/{client}/{produit}', [App\Http\Controllers\HystoriqprixController::class, 'gethystorique']);
Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');
//Route::get('/dashboard', [App\Http\Controllers\HomeController::class, 'dash']);



Route::get('/dashboard', [App\Http\Controllers\HomeController::class, 'dash'])
    ->middleware('role:admin')
    ->name('dash');





Route::get('/categorie1', [App\Http\Controllers\CategorieController::class, 'create']);
Route::post('/ianactive/{id}', [App\Http\Controllers\ActivebuttonController::class, 'ianactive']);

Route::get('/topcatsup/{id}', [App\Http\Controllers\TopcatController::class, 'destroy']);
Route::post('/modiftopcat/{id}', [App\Http\Controllers\TopcatController::class, 'update']);
Route::get('/searchecat', [App\Http\Controllers\TopcatController::class,'searchecat'])->name('searchecat');


Route::get('/topcat1', [App\Http\Controllers\TopcatController::class, 'create']);
Route::post('/addtopcat', [App\Http\Controllers\TopcatController::class, 'store']);
Route::post('/addbanque', [App\Http\Controllers\BanqueController::class, 'store']);

//Route::post('/test2', [App\Http\Controllers\TestController::class, 'store']);


Route::post('/modiflieustock/{id}', [App\Http\Controllers\LieustockController::class, 'update']);

Route::post('/modifdepense/{id}', [App\Http\Controllers\DepenseController::class, 'update']);
Route::get('/suplieu/{id}', [App\Http\Controllers\LieustockController::class, 'destroy']);
Route::get('/supdepense/{id}', [App\Http\Controllers\DepenseController::class, 'destroy']);
Route::get('/supachat/{id}', [App\Http\Controllers\AchatController::class, 'destroy']);
Route::get('/supavoir/{id}', [App\Http\Controllers\AvoirController::class, 'destroy']);
Route::get('/enatted_toconfirm/{id}', [App\Http\Controllers\VenteController::class, 'enatted_toconfirm']);
Route::post('/addproduit2', [App\Http\Controllers\ProduitController::class, 'addproduit2']);
Route::get('/destroy_enattend/{id}', [App\Http\Controllers\VenteController::class, 'destroy_enattend']);
//
Route::get('/supdevis/{id}', [App\Http\Controllers\DevisController::class, 'destroy']);
Route::get('/supcommande/{id}', [App\Http\Controllers\BoncommandeController::class, 'destroy']);

Route::post('/addcatdepense', [App\Http\Controllers\CatdepenseController::class, 'store']);
Route::post('/modifcatdepense/{id}', [App\Http\Controllers\CatdepenseController::class, 'update']);
Route::get('/catdepense', [App\Http\Controllers\CatdepenseController::class, 'index']);
Route::get('/supcatdepense/{id}', [App\Http\Controllers\CatdepenseController::class, 'destroy']);

Route::get('/cheque', [App\Http\Controllers\ChequeController::class, 'cheque']);
Route::get('/info', [App\Http\Controllers\InfoController::class, 'info']);
Route::post('/addinfo', [App\Http\Controllers\InfoController::class, 'store']);
Route::get('/stock', [App\Http\Controllers\StockController::class, 'index']);
Route::get('/fournisseurs1', [App\Http\Controllers\FournisseurController::class, 'index']);
Route::get('/fournisseurs', [App\Http\Controllers\FournisseurController::class, 'fournisseurs']);
Route::get('/clients1', [App\Http\Controllers\ClientController::class, 'index']);
Route::get('/cientsup/{id}', [App\Http\Controllers\ClientController::class, 'destroy']);
Route::get('/fournissersup/{id}', [App\Http\Controllers\FournisseurController::class, 'destroy']);

Route::post('/modiif_reglement/{id}', [App\Http\Controllers\ReglementClController::class, 'modiif_reglement']);
Route::get('/caisse/chercher-par-date', [App\Http\Controllers\CaisseController::class, 'chercherParDate'])->name('caisse.chercherParDate');



Route::post('/liquidation', [App\Http\Controllers\ClientController::class, 'liquidation']);
Route::get('/blenatted', [App\Http\Controllers\VenteController::class, 'blenatted']);
Route::get('/caissebl', [App\Http\Controllers\VenteController::class, 'caissebl']);

Route::get('/blconfirme', [App\Http\Controllers\VenteController::class, 'blconfirme']);
Route::get('/modifevente/{id}', [App\Http\Controllers\VenteController::class, 'modifevente']);

Route::post('/modif_avoir', [App\Http\Controllers\AvoirController::class, 'modif_avoir']);
Route::get('/searchinv', [App\Http\Controllers\ProduitController::class, 'searchinv']);
Route::get('/chercheproduit', [App\Http\Controllers\ProduitController::class, 'chercheproduit']);
Route::get('/searchepc/{id}', [App\Http\Controllers\ProduitController::class, 'searchepc']);

Route::get('/modifevente2', [App\Http\Controllers\VenteController::class, 'modifevente2']);
Route::post('/reglevente', [App\Http\Controllers\VenteController::class, 'reglevente']);
Route::get('/produitparcat/{id}', [App\Http\Controllers\ProduitController::class, 'produitparcat']);
Route::get('/client_errecouvrable', [App\Http\Controllers\ClientController::class, 'irrecouvrableclients']);
Route::post('/qtyupdat/{id}', [App\Http\Controllers\ProduitController::class, 'qtyupdat']);
Route::get('/entrer/{id}', [App\Http\Controllers\StockController::class, 'entrer']);
Route::get('/sortie/{id}', [App\Http\Controllers\StockController::class, 'sortie']);
Route::get('/vente', [App\Http\Controllers\VenteController::class, 'index']);
Route::get('/achat', [App\Http\Controllers\AchatController::class, 'index']);

Route::get('/commande', [App\Http\Controllers\BoncommandeController::class, 'index']);
Route::get('/facturboncommande', [App\Http\Controllers\BoncommandeController::class, 'facturboncommande']);
Route::get('/blurgent', [App\Http\Controllers\VenteController::class, 'blurgent']);
Route::get('/facturvente', [App\Http\Controllers\VenteController::class, 'facturvente']);
Route::get('/bonlivraison', [App\Http\Controllers\VenteController::class, 'bonlivraison']);
Route::get('/detaillefacturvente/{id}', [App\Http\Controllers\VenteController::class, 'detaillefacturvente']);
Route::get('/reglementclient', [App\Http\Controllers\VenteController::class, 'reglementclient']);
Route::get('/reglementclient_all', [App\Http\Controllers\VenteController::class, 'reglementclient_all']);
Route::get('/modifevente', [App\Http\Controllers\VenteController::class, 'modifevente']);

Route::get('/facturachat', [App\Http\Controllers\AchatController::class, 'facturachat']);
Route::get('/devis', [App\Http\Controllers\DevisController::class, 'index']);
Route::get('/facturdevis', [App\Http\Controllers\DevisController::class, 'facturdevis']);

Route::get('/document', [App\Http\Controllers\ProduitController::class, 'document']);
Route::get('/comptabilite', [App\Http\Controllers\ProduitController::class, 'comptabilite']);
Route::get('/ventepdf/{id}', [App\Http\Controllers\PdfController::class, 'ventepdf']);
Route::get('/achatpdf/{id}', [App\Http\Controllers\PdfController::class, 'achatpdf']);
Route::get('/boncommandepdf/{id}', [App\Http\Controllers\PdfController::class, 'comandepdf']);

Route::get('/avoirpdf/{id}', [App\Http\Controllers\PdfController::class, 'avoirpdf']);
Route::get('/enattendpdf/{id}', [App\Http\Controllers\PdfController::class, 'enattendpdf']);

Route::get('/chercheproduit', [App\Http\Controllers\ProduitController::class, 'chercheproduit']);
Route::get('/lastid', [App\Http\Controllers\ProduitController::class, 'lastid']);

Route::get('/modifrix', [App\Http\Controllers\ProduitController::class, 'modifrix']);
Route::post('/modifrixstor', [App\Http\Controllers\ProduitController::class, 'modifrixstor']);

Route::get('/ventepdf/{id}', [App\Http\Controllers\PdfController::class, 'ventepdf']);
Route::get('/ventepdfsansentete/{id}', [App\Http\Controllers\PdfController::class, 'ventepdfsansentete']);




Route::get('/bonlivraisonpdf/{id}', [App\Http\Controllers\PdfController::class, 'bonlivraisonpdf']);
Route::get('/devispdf/{id}', [App\Http\Controllers\PdfController::class, 'devispdf']);






Route::get('/chart', [App\Http\Controllers\ProduitController::class, 'chart']);

Route::get('/test', [App\Http\Controllers\BonlivraisonController::class, 'test']);

//json
Route::get('/produits', [App\Http\Controllers\ProduitController::class, 'produits']);

Route::get('/modepayements', [App\Http\Controllers\ModepayementController::class, 'index']);
Route::get('/produitbyid/{id}', [App\Http\Controllers\ProduitController::class, 'produitbyid']);
Route::get('/getproduitbycat/{id}', [App\Http\Controllers\ProduitController::class, 'getproduitbycat']);

Route::get('/date_client/{id}', [App\Http\Controllers\ClientController::class, 'date_client']);
Route::get('/date_vente', [App\Http\Controllers\VenteController::class, 'date_vente']);
Route::get('/date', [App\Http\Controllers\ClientController::class, 'date']);

Route::get('/detaille_client/{id}', [App\Http\Controllers\ClientController::class, 'detaille_client']);
Route::get('/clients', [App\Http\Controllers\ClientController::class, 'clients']);
Route::get('/clientbyid/{id}', [App\Http\Controllers\ClientController::class, 'clientbyid']);
Route::post('/modifclient/{id}', [App\Http\Controllers\ClientController::class, 'modifclient']);
Route::post('/modiffacture/{id}', [App\Http\Controllers\ClientController::class, 'modiffacture']);

Route::get('/fournisseurs', [App\Http\Controllers\FournisseurController::class, 'fournisseurs']);
Route::get('/fournisseurbyid/{id}', [App\Http\Controllers\FournisseurController::class, 'fournisseurbyid']);



Route::get('/lieustock', [App\Http\Controllers\LieustockController::class, 'index']);
Route::post('/addlieustock', [App\Http\Controllers\LieustockController::class, 'store']);

Route::get('/categorie', [App\Http\Controllers\CategorieController::class, 'categorie']);
Route::post('/addcategorie', [App\Http\Controllers\CategorieController::class, 'store']);

Route::get('/mettre', [App\Http\Controllers\MettreController::class, 'index']);
Route::post('/addmettre', [App\Http\Controllers\MettreController::class, 'store']);
Route::get('/deletemettre/{id}', [App\Http\Controllers\MettreController::class, 'destroy']);
Route::post('/updatmettre/{id}', [App\Http\Controllers\MettreController::class, 'update']);

Route::get('/alimentcaisse', [App\Http\Controllers\AlimentcaisseController::class, 'index']);
Route::post('/addalimentcaisse', [App\Http\Controllers\AlimentcaisseController::class, 'store']);
Route::post('/updatalimentcaisse/{id}', [App\Http\Controllers\AlimentcaisseController::class, 'update']);
Route::get('/deletealimentcaisse/{id}', [App\Http\Controllers\AlimentcaisseController::class, 'destroy']);






Route::get('/depense', [App\Http\Controllers\DepenseController::class, 'index']);
Route::get('/inventair', [App\Http\Controllers\ProduitController::class, 'inventair']);
Route::get('/produit', [App\Http\Controllers\ProduitController::class, 'index']);
Route::get('/detaille/{id}', [App\Http\Controllers\ProduitController::class, 'show']);


Route::get('/produits/recherche', [App\Http\Controllers\ProduitController::class, 'search'])->name('produits.search');
Route::get('/produits/alert', [App\Http\Controllers\ProduitController::class, 'searchealert'])->name('produits.alert');


Route::get('/detaille/{id}', [App\Http\Controllers\ProduitController::class, 'show']);
Route::get('/deleteproduit/{id}', [App\Http\Controllers\ProduitController::class, 'destroy']);
Route::post('/addproduit/{id}', [App\Http\Controllers\ProduitController::class, 'store']);
Route::post('/adddeense', [App\Http\Controllers\DepenseController::class, 'store']);
Route::post('/updatproduit/{id}', [App\Http\Controllers\ProduitController::class, 'updatproduit']);
Route::post('/mdiflientlient/{id}', [App\Http\Controllers\ClientController::class, 'update']);
Route::post('/mdiffr/{id}', [App\Http\Controllers\FournisseurController::class, 'update']);
Route::post('/addstock', [App\Http\Controllers\StockController::class, 'store']);
Route::post('/addfournisseur', [App\Http\Controllers\FournisseurController::class, 'store']);
Route::post('/addclient', [App\Http\Controllers\ClientController::class, 'store']);
Route::post('/addvente', [App\Http\Controllers\VenteController::class, 'store']);
Route::post('/adddevis', [App\Http\Controllers\DevisController::class, 'store']);
Route::post('/modifier_vente/{id}', [App\Http\Controllers\VenteController::class, 'modifier_vente']);
Route::post('/modifier_avoir/{id}', [App\Http\Controllers\AvoirController::class, 'modifier_avoir']);

Route::post('/mdifdate/{id}', [App\Http\Controllers\VenteController::class, 'mdifdate']);

Route::post('/modifier_achat/{id}', [App\Http\Controllers\AchatController::class, 'modifier_achat']);

Route::post('/newavoir', [App\Http\Controllers\AvoirController::class, 'store']);
Route::get('/avoir', [App\Http\Controllers\AvoirController::class, 'avoir']);


Route::post('/newdevis', [App\Http\Controllers\DevisController::class, 'store']);
Route::post('/newcommande', [App\Http\Controllers\BoncommandeController::class, 'store']);
Route::get('/facture_avoir', [App\Http\Controllers\AvoirController::class, 'facture_avoir']);




Route::post('/modif_achat', [App\Http\Controllers\AchatController::class, 'modif_achat']);
Route::post('/addachat2', [App\Http\Controllers\AchatController::class, 'storetest']);
Route::get('/all_ventes', [App\Http\Controllers\VenteController::class, 'all_ventes']);

Route::get('/deletevente/{id}', [App\Http\Controllers\VenteController::class, 'destroy']);
Route::delete('/deletelignevente/{id}', [App\Http\Controllers\VenteController::class, 'deletelignevente']);

Route::get('/deletenttend/{id}', [App\Http\Controllers\EnattendController::class, 'deletenttend']);

Route::delete('/deletligneachat/{id}', [App\Http\Controllers\AchatController::class, 'deletligneachat']);
Route::post('/addachat', [App\Http\Controllers\AchatController::class, 'store']);
Route::post('/adddevis', [App\Http\Controllers\DevisController::class, 'store']);
Route::post('/addboncommande', [App\Http\Controllers\BoncommandeController::class, 'store']);

Route::get('/caisse', [App\Http\Controllers\CaisseController::class, 'index']);
//admindash
