<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>Facture</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0; padding: 0;
            background-color: #fff;
            color: #333;
        }
        .invoice-box {
            max-width: 800px;
            margin: 30px auto;
            padding: 30px;
            background-color: #fff;
            box-shadow: 0 0 10px rgba(0,0,0,0.1);
            page-break-inside: avoid;
        }

        /* Header 50/50 */
.header {
  display: flex;
  align-items: center;  /* centre verticalement */
  justify-content: center; /* centre horizontalement tout le groupe */
  gap: 10px; /* espace entre logo et texte */
  margin-bottom: 40px;
}

.logo {
  width: 30px;
  height: 30px;
  flex-shrink: 0;
}

.logo img {
  width: 40px;
  height: 40px;
  object-fit: contain;
}

.company-name {
  font-size: 1.8rem;
  font-weight: bold;
  color: #222;
  line-height: 40px; /* même hauteur que l’image */
}


        .info-container {
            display: table;
            width: 100%;
            margin-bottom: 25px;
        }

        .company-info,
        .client-info {
            display: table-cell;
            width: 50%;
            vertical-align: top;
        }

        .client-info {
            padding: 10px;
            border: 1px solid #ddd;
            border-radius: 5px;
            background-color: #f9f9f9;
        }

        .invoice-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
            page-break-inside: avoid;
        }

        .invoice-table th, 
        .invoice-table td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }

        .invoice-table th {
            background-color: #f2f2f2;
        }

        .totals-container {
            text-align: right;
            margin-top: 20px;
        }

        .totals-container p {
            margin: 5px 0;
        }

        .total-amount {
            font-size: 1.5em;
            color: #333;
        }

        .payment-method {
            text-align: right;
            margin-top: 10px;
        }

        .payment-method p {
            margin: 5px 0;
        }

     .footer {
    width: 100%;
    position: fixed;
    bottom: 0;
    left: 0;
    right: 0;
    background-color: #fff;
    text-align: center;
    font-size: 0.7rem;      /* texte plus petit */
    padding: 4px 0;         /* padding vertical réduit */
    border-top: 1px solid #ddd;
    line-height: 1.1;       /* hauteur de ligne serrée */
}

.footer p {
    margin: 2px 0;          /* marges top/bottom très petites */
    font-weight: normal;
}

        /* Pour gérer les descriptions longues */
        .description-cell {
            word-wrap: break-word;
            white-space: normal;
            max-width: 200px;
            text-align: justify;
            vertical-align: top;
        }
    </style>
</head>
<body>

    <div class="invoice-box">
        <!-- En-tête -->

<div class="header">
   <div class="logo">
    <?php if(!empty($info->logo) && file_exists(public_path('img/' . $info->logo))): ?>
      <img src="data:image/png;base64,<?php echo e(base64_encode(file_get_contents(public_path('img/' . $info->logo)))); ?>" alt="Logo" />
    <?php else: ?>
      <img src="data:image/png;base64,<?php echo e(base64_encode(file_get_contents(public_path('img/777.jpg')))); ?>" alt="Logo par défaut" />
    <?php endif; ?>
  </div>
  <div class="company-name">
    <?php echo e($info->nom ?? 'Nom de la Société'); ?>

  </div>
</div>
        <!-- Infos livraison / client -->
        <div class="info-container">
            <div class="company-info">
                <p style="font-weight: bold;">Facture N° : <?php echo e($ventes->ref); ?></p>
                <p>Date : <?php echo e($ventes->created_at); ?></p>
            </div>
            <div class="client-info">
                <p><strong>Facturé à :</strong></p>
                <p>Nom : <?php echo e($ventes->client->nom); ?></p>
                <p>Ice : <?php echo e($ventes->client->ice); ?></p>
                <p>Téléphone : <?php echo e($ventes->client->tele); ?></p>
            </div>
        </div>

        <!-- Tableau des produits -->
        <table class="invoice-table">
            <thead>
                <tr style="text-align: center;">
                    <th>Désignation</th>
                    <th>PU</th>
                    <th>Qté</th>
                  
                    <th>Total</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $ventes->detaille_vente; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $det): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td class="description-cell"><?php echo e($det->desc); ?></td>
                    <td><?php echo e($det->prix_vente); ?></td>
                    <td><?php echo e($det->quantite); ?></td>
                  
                    <td><?php echo e($det->total); ?></td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>

        <!-- Totaux -->
 <!-- Totaux -->
<div class="totals-container">
    <?php if($ventes->totalTVA == 0): ?>
        <!-- TVA = 0 : afficher juste "Total" -->
        <p><strong>Total : <span class="total-amount"><?php echo e($ventes->prixtotal); ?> DH</span></strong></p>
    <?php else: ?>
        <!-- TVA > 0 : afficher Total, remise, TVA, Total TTC -->
        <p>Total : <?php echo e($ventes->prixtotal); ?> DH</p>

        <?php if($ventes->totalremise > 0): ?>
            <p>Remise : <?php echo e($ventes->totalremise); ?> DH</p>
        <?php endif; ?>

        <p>TVA : <?php echo e($ventes->totalTVA); ?> DH</p>

        <p><strong>Total TTC : <span class="total-amount"><?php echo e($ventes->totalavecTVA); ?> DH</span></strong></p>
    <?php endif; ?>
</div>

<div class="payment-method">
    <p>Mode de paiement : <?php echo e($ventes->modepayement->mode); ?></p>

    <?php if($ventes->modepayement->id == 2): ?>
        
        <?php if($ventes->avance > 0): ?>
            <p>Avance : <?php echo e(number_format($ventes->avance, 2)); ?> DH</p>
        <?php endif; ?>

        <?php if($ventes->rest > 0): ?>
            <p>Reste : <?php echo e(number_format($ventes->rest, 2)); ?> DH</p>
        <?php endif; ?>
    <?php endif; ?>
</div>




    </div>

    <!-- Footer -->
    <div class="footer">
        <p><?php echo e($info->line1 ?? ''); ?></p>
        <p><?php echo e($info->line2 ?? ''); ?></p>
        <p><?php echo e($info->line3 ?? ''); ?></p>
    </div>

</body>
</html>
<?php /**PATH C:\xampp\htdocs\khyat\resources\views/pdf/facturvente.blade.php ENDPATH**/ ?>