<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Facture</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
            background-color: #fff;
            position: relative;
        }

        .invoice-box {
            max-width: 800px;
            margin: 0 auto;
            padding: 30px;
            background-color: #fff;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.15);
            page-break-inside: avoid;
        }

        h1 {
            text-align: center;
            color: #333;
            margin-top: 0;
        }

        .invoice-date {
            text-align: right;
            margin-bottom: 20px;
            font-style: italic;
        }

        .info-container {
            display: table;
            width: 100%;
            margin-bottom: 20px;
        }

        .company-info,
        .client-info {
            display: table-cell;
            width: 50%;
            vertical-align: top;
        }

        .client-info {
            padding: 10px;
            border: 1px solid #ddd;
            border-radius: 5px;
            background-color: #f9f9f9;
        }

        .invoice-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
            page-break-inside: avoid;
        }

        .invoice-table th, .invoice-table td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }

        .invoice-table th {
            background-color: #f2f2f2;
        }

        .totals-container {
            text-align: right;
            margin-top: 20px;
        }

        .totals-container p {
            margin: 5px 0;
        }

        .total-amount {
            font-size: 1.5em;
            color: #333;
        }

        .total-in-words {
            font-style: italic;
            font-size: 0.9em;
        }

        .payment-method {
            text-align: right;
            margin-top: 10px;
        }

        .payment-method p {
            margin: 5px 0;
        }

        .separator-line {
            border: none;
            border-top: 2px solid #ddd;
            margin: 20px 0;
        }

        .footer {
            width: 100%;
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
          
            background-color: #fff;
            text-align: center;
            font-size: 0.9em;
          
          
        }

        .footer p {
            margin: 5px 0;
        }

        .invoice-table {
            width: 100%;
            border-collapse: collapse;
        }

        .invoice-table th, .invoice-table td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: justify; /* Alignement par défaut pour toutes les cellules */
        }

        .description-cell {
            word-wrap: break-word; /* Gère les mots longs */
            white-space: normal;   /* Permet le retour à la ligne */
            max-width: 200px;      /* Limite la largeur de cette colonne */
            text-align: justify;   /* Justifie le texte dans cette cellule */
            vertical-align: top;   /* Aligne le texte en haut si nécessaire */
        }
    </style>
</head>
<body>
    <img src="data:image/png;base64,<?php echo e(base64_encode(file_get_contents(public_path('img/777.jpg')))); ?>" alt="Logo" />

    <div class="invoice-box">
       

        <div class="info-container">
            <div class="company-info">
                <p style="font-weight: bold">Bon de Livraison N :<?php echo e($ventes->ref); ?> </p>
                <p >Date : <?php echo e($ventes->created_at); ?></p>
            </div>
    

            <div class="client-info">
                <p><strong>Facturé à :</strong></p>
                <p> Nom :<?php echo e($ventes->client->nom); ?></p>
                <p> Ice :<?php echo e($ventes->client->ice); ?></p>
                <p>Téléphone: <?php echo e($ventes->client->tele); ?></p>
            
            </div>
        </div>

        <table class="invoice-table">
            <thead>
                <tr style="text-align: center">
                    <th>Designation</th>
                      <th>PU</th>
                    <th>qty</th>
                
                    <th>tva</th>
                    <th>remise</th>
                    <th>TOTAL</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $ventes->detaille_vente; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $det): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td class="description-cell">
                            <?php echo e($det->desc); ?> <br>
                        
                        </td>
                          <td><?php echo e($det->prix_vente); ?></td>
                        <td><?php echo e($det->quantite); ?></td>
                        <td><?php echo e($det->tva); ?> %</td>
                        <td><?php echo e($det->remise); ?> %</td>
                        <td><?php echo e($det->total); ?></td>
                   
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>

        <div class="totals-container">
            <p>Total HT : <?php echo e($ventes->prixtotal); ?> DH</p>
            <p>Remise :  <?php echo e($ventes->totalremise); ?> DH</p>
            <p>TVA: <?php echo e($ventes->totalTVA); ?> DH</p>
            <p><strong>Total TTC : <span class="total-amount"><?php echo e($ventes->totalavecTVA); ?> DH</span></strong></p>
            <p class="total-in-words"></p>
        </div>

        <div class="payment-method">
         <p>Mode de paiement:  <?php echo e($ventes->modepayement->mode); ?> </p> 
        </div>
    </div>

    <div class="footer">
      
            <img src="data:image/png;base64,<?php echo e(base64_encode(file_get_contents(public_path('img/6666.jpg')))); ?>" alt="Logo" />
    
    </div>
</body>
</html><?php /**PATH C:\xampp\htdocs\sd\resources\views/pdf/bonlivraison.blade.php ENDPATH**/ ?>